/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.api.ports;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.identity.domain.BunkerIdentity;
import xyz.tcheeric.identity.domain.PublicKey;

public interface BunkerConnectionPort {
    public CompletableFuture<Void> connect();

    public CompletableFuture<Void> disconnect();

    public boolean isConnected();

    public ConnectionState getConnectionState();

    public CompletableFuture<String> ping();

    public CompletableFuture<HealthStatus> healthCheck();

    public CompletableFuture<BunkerIdentity> createKey(String var1, String var2);

    public CompletableFuture<BunkerIdentity> importKey(String var1, String var2, String var3);

    public CompletableFuture<List<BunkerIdentity>> listKeys();

    public CompletableFuture<Optional<BunkerIdentity>> getKey(String var1);

    public CompletableFuture<Optional<BunkerIdentity>> findKeyByPublicKey(PublicKey var1);

    public CompletableFuture<Boolean> unlockKey(String var1, String var2);

    public CompletableFuture<Boolean> deleteKey(String var1);

    public String getBunkerPubkey();

    public List<String> getRelays();

    public void setConnectionTimeout(Duration var1);

    public void setRequestTimeout(Duration var1);

    public record HealthStatus(boolean healthy, boolean connected, long latencyMs, int keyCount, long lastPingTime, String errorMessage) {
        public static HealthStatus healthy(long latencyMs, int keyCount) {
            return new HealthStatus(true, true, latencyMs, keyCount, System.currentTimeMillis(), null);
        }

        public static HealthStatus unhealthy(String errorMessage) {
            return new HealthStatus(false, false, -1L, 0, 0L, errorMessage);
        }

        public static HealthStatus disconnected() {
            return new HealthStatus(false, false, -1L, 0, 0L, "Not connected to bunker");
        }
    }

    public static enum ConnectionState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        FAILED;

    }
}

