/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.api.ports;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.identity.domain.MerchantProfile;
import xyz.tcheeric.identity.domain.PaymentMethod;
import xyz.tcheeric.identity.domain.ProfileMetadata;

public interface ProfilePort {
    public CompletableFuture<Optional<ProfileMetadata>> getProfile(String var1);

    public CompletableFuture<Void> updateProfile(String var1, ProfileMetadata var2);

    public CompletableFuture<Optional<MerchantProfile>> getMerchantProfile(String var1);

    public CompletableFuture<Void> setMerchantProfile(String var1, MerchantProfile var2);

    public CompletableFuture<Void> disableMerchant(String var1);

    public CompletableFuture<Void> deleteMerchantProfile(String var1);

    default public CompletableFuture<Boolean> isMerchant(String pubkey) {
        return this.getMerchantProfile(pubkey).thenApply(Optional::isPresent);
    }

    default public CompletableFuture<Boolean> isMerchantActive(String pubkey) {
        return this.getMerchantProfile(pubkey).thenApply(opt -> opt.map(MerchantProfile::isActive).orElse(false));
    }

    default public CompletableFuture<List<String>> getMerchantCategories(String pubkey) {
        return this.getMerchantProfile(pubkey).thenApply(opt -> opt.map(MerchantProfile::getCategories).orElse(List.of()));
    }

    default public CompletableFuture<Set<PaymentMethod>> getMerchantPaymentMethods(String pubkey) {
        return this.getMerchantProfile(pubkey).thenApply(opt -> opt.map(MerchantProfile::getPaymentMethods).orElse(Set.of()));
    }

    default public CompletableFuture<Boolean> merchantAcceptsPaymentMethod(String pubkey, PaymentMethod paymentMethod) {
        return this.getMerchantProfile(pubkey).thenApply(opt -> opt.map(p -> p.acceptsPaymentMethod(paymentMethod)).orElse(false));
    }

    default public CompletableFuture<Boolean> merchantAcceptsLightning(String pubkey) {
        return this.merchantAcceptsPaymentMethod(pubkey, PaymentMethod.LIGHTNING);
    }

    default public CompletableFuture<Boolean> merchantAcceptsEcash(String pubkey) {
        return this.merchantAcceptsPaymentMethod(pubkey, PaymentMethod.ECASH);
    }
}

