/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application;

import java.time.Instant;
import java.util.Objects;
import xyz.tcheeric.identity.api.exceptions.IdentityException;
import xyz.tcheeric.identity.api.ports.IdentityRepository;
import xyz.tcheeric.identity.domain.Identity;
import xyz.tcheeric.identity.domain.PrivateKey;
import xyz.tcheeric.identity.domain.PublicKey;

public class CreateIdentityUseCase {
    private final IdentityRepository repository;

    public CreateIdentityUseCase(IdentityRepository repository) {
        this.repository = Objects.requireNonNull(repository, "IdentityRepository cannot be null");
    }

    public Identity execute(String label, PublicKey publicKey, PrivateKey privateKey) {
        Objects.requireNonNull(label, "Label cannot be null");
        Objects.requireNonNull(publicKey, "Public key cannot be null");
        Objects.requireNonNull(privateKey, "Private key cannot be null");
        Identity identity = new Identity(label, publicKey, privateKey);
        if (this.repository.findByPublicKey(publicKey).isPresent()) {
            throw new IdentityException("An identity with this public key already exists: " + publicKey.toHex());
        }
        this.repository.save(identity);
        return identity;
    }

    public Identity execute(String id, String label, PublicKey publicKey, PrivateKey privateKey) {
        Objects.requireNonNull(id, "ID cannot be null");
        Objects.requireNonNull(label, "Label cannot be null");
        Objects.requireNonNull(publicKey, "Public key cannot be null");
        Objects.requireNonNull(privateKey, "Private key cannot be null");
        if (this.repository.exists(id)) {
            throw new IdentityException("An identity with this ID already exists: " + id);
        }
        if (this.repository.findByPublicKey(publicKey).isPresent()) {
            throw new IdentityException("An identity with this public key already exists: " + publicKey.toHex());
        }
        Identity identity = new Identity(id, label, publicKey, privateKey, Instant.now(), null);
        this.repository.save(identity);
        return identity;
    }
}

