/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases;

import xyz.tcheeric.identity.api.ports.AuthenticationPort;

public class RegisterPluginUseCase {
    private final AuthenticationPort authenticationPort;

    public RegisterPluginUseCase(AuthenticationPort authenticationPort) {
        if (authenticationPort == null) {
            throw new IllegalArgumentException("authenticationPort cannot be null");
        }
        this.authenticationPort = authenticationPort;
    }

    public RegisterPluginResult execute(String pluginName, String pluginVersion) {
        if (pluginName == null || pluginName.isBlank()) {
            return RegisterPluginResult.failure("Plugin name cannot be null or blank");
        }
        if (pluginVersion == null || pluginVersion.isBlank()) {
            return RegisterPluginResult.failure("Plugin version cannot be null or blank");
        }
        try {
            String authToken = this.authenticationPort.generateToken(pluginName);
            return RegisterPluginResult.success(authToken);
        }
        catch (Exception e) {
            return RegisterPluginResult.failure("Failed to generate authentication token: " + e.getMessage());
        }
    }

    public record RegisterPluginResult(boolean success, String authToken, String errorMessage) {
        public RegisterPluginResult {
            if (success && (authToken == null || authToken.isBlank())) {
                throw new IllegalArgumentException("authToken must be provided when success is true");
            }
            if (!success && (errorMessage == null || errorMessage.isBlank())) {
                throw new IllegalArgumentException("errorMessage must be provided when success is false");
            }
        }

        public static RegisterPluginResult success(String authToken) {
            if (authToken == null || authToken.isBlank()) {
                throw new IllegalArgumentException("authToken cannot be null or blank for success result");
            }
            return new RegisterPluginResult(true, authToken, null);
        }

        public static RegisterPluginResult failure(String errorMessage) {
            if (errorMessage == null || errorMessage.isBlank()) {
                throw new IllegalArgumentException("errorMessage cannot be null or blank for failure result");
            }
            return new RegisterPluginResult(false, null, errorMessage);
        }
    }
}

