/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.policy;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.domain.PolicyRule;
import xyz.tcheeric.identity.domain.SigningPolicy;

public class CreatePolicyUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreatePolicyUseCase.class);
    private final PolicyPort policyPort;

    public CreatePolicyUseCase(PolicyPort policyPort) {
        this.policyPort = Objects.requireNonNull(policyPort, "Policy port cannot be null");
    }

    public CompletableFuture<SigningPolicy> execute(CreatePolicyRequest request) {
        Objects.requireNonNull(request, "Request cannot be null");
        LOGGER.info("create_policy_started policy_name={} rules_count={} has_expiration={}", request.name(), request.rules() != null ? request.rules().size() : 0, request.expiration() != null);
        SigningPolicy policy = this.buildPolicy(request);
        return this.policyPort.createPolicy(policy).whenComplete((created, error) -> {
            if (error != null) {
                LOGGER.error("create_policy_failed policy_name={} error={}", request.name(), error.getMessage(), error);
            } else {
                LOGGER.info("create_policy_complete policy_id={} policy_name={} rules_count={}", created.getId(), created.getName(), created.getRuleCount());
            }
        });
    }

    private SigningPolicy buildPolicy(CreatePolicyRequest request) {
        SigningPolicy policy = new SigningPolicy(request.name(), request.description());
        if (request.rules() != null) {
            for (PolicyRule rule : request.rules()) {
                policy = policy.addRule(rule);
            }
        }
        if (request.expiration() != null) {
            policy = policy.withExpiration(request.expiration());
        }
        return policy;
    }

    public record CreatePolicyRequest(String name, String description, List<PolicyRule> rules, Duration expiration) {
        public CreatePolicyRequest(String name) {
            this(name, null, null, null);
        }

        public CreatePolicyRequest(String name, List<PolicyRule> rules) {
            this(name, null, rules, null);
        }

        public CreatePolicyRequest {
            Objects.requireNonNull(name, "Policy name cannot be null");
            if (name.trim().isEmpty()) {
                throw new IllegalArgumentException("Policy name cannot be empty");
            }
        }
    }

    public record CreatePolicyResult(boolean success, SigningPolicy policy, String errorMessage) {
        public static CreatePolicyResult success(SigningPolicy policy) {
            Objects.requireNonNull(policy, "Policy cannot be null for success result");
            return new CreatePolicyResult(true, policy, null);
        }

        public static CreatePolicyResult failure(String errorMessage) {
            Objects.requireNonNull(errorMessage, "Error message cannot be null for failure result");
            return new CreatePolicyResult(false, null, errorMessage);
        }
    }
}

