/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.policy;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.domain.SigningPolicy;

public class ListPoliciesUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListPoliciesUseCase.class);
    private final PolicyPort policyPort;

    public ListPoliciesUseCase(PolicyPort policyPort) {
        this.policyPort = Objects.requireNonNull(policyPort, "Policy port cannot be null");
    }

    public CompletableFuture<List<SigningPolicy>> execute() {
        LOGGER.debug("list_policies_started");
        return this.policyPort.listPolicies().whenComplete((policies, error) -> {
            if (error != null) {
                LOGGER.error("list_policies_failed error={}", (Object)error.getMessage(), error);
            } else {
                LOGGER.debug("list_policies_complete count={}", (Object)policies.size());
            }
        });
    }

    public CompletableFuture<List<SigningPolicy>> execute(PolicyFilter filter2) {
        Objects.requireNonNull(filter2, "Filter cannot be null");
        LOGGER.debug("list_policies_filtered active_only={} valid_only={} key_name={}", filter2.activeOnly(), filter2.validOnly(), filter2.keyName());
        CompletableFuture<List<SigningPolicy>> baseFuture = filter2.keyName() != null ? this.policyPort.listPoliciesForKey(filter2.keyName()) : this.policyPort.listPolicies();
        return ((CompletableFuture)baseFuture.thenApply(policies -> this.applyFilters((List<SigningPolicy>)policies, filter2))).whenComplete((policies, error) -> {
            if (error != null) {
                LOGGER.error("list_policies_filtered_failed error={}", (Object)error.getMessage(), error);
            } else {
                LOGGER.debug("list_policies_filtered_complete count={}", (Object)policies.size());
            }
        });
    }

    public CompletableFuture<Optional<SigningPolicy>> getById(String policyId) {
        Objects.requireNonNull(policyId, "Policy ID cannot be null");
        LOGGER.debug("get_policy_by_id policy_id={}", (Object)policyId);
        return this.policyPort.getPolicy(policyId).whenComplete((policy, error) -> {
            if (error != null) {
                LOGGER.error("get_policy_by_id_failed policy_id={} error={}", policyId, error.getMessage(), error);
            } else {
                LOGGER.debug("get_policy_by_id_complete policy_id={} found={}", (Object)policyId, (Object)policy.isPresent());
            }
        });
    }

    public CompletableFuture<List<SigningPolicy>> findByName(String namePattern) {
        Objects.requireNonNull(namePattern, "Name pattern cannot be null");
        LOGGER.debug("find_policies_by_name pattern={}", (Object)namePattern);
        String lowerPattern = namePattern.toLowerCase();
        return ((CompletableFuture)this.policyPort.listPolicies().thenApply(policies -> policies.stream().filter(p -> p.getName().toLowerCase().contains(lowerPattern)).collect(Collectors.toList()))).whenComplete((policies, error) -> {
            if (error != null) {
                LOGGER.error("find_policies_by_name_failed pattern={} error={}", namePattern, error.getMessage(), error);
            } else {
                LOGGER.debug("find_policies_by_name_complete pattern={} count={}", (Object)namePattern, (Object)policies.size());
            }
        });
    }

    public CompletableFuture<PolicyStatistics> getStatistics() {
        LOGGER.debug("get_policy_statistics_started");
        return ((CompletableFuture)this.policyPort.listPolicies().thenApply(policies -> {
            long total = policies.size();
            long active = policies.stream().filter(SigningPolicy::isActive).count();
            long expired = policies.stream().filter(SigningPolicy::isExpired).count();
            long valid = policies.stream().filter(SigningPolicy::isValid).count();
            return new PolicyStatistics(total, active, expired, valid);
        })).whenComplete((stats, error) -> {
            if (error != null) {
                LOGGER.error("get_policy_statistics_failed error={}", (Object)error.getMessage(), error);
            } else {
                LOGGER.debug("get_policy_statistics_complete total={} active={} expired={} valid={}", stats.totalCount(), stats.activeCount(), stats.expiredCount(), stats.validCount());
            }
        });
    }

    private List<SigningPolicy> applyFilters(List<SigningPolicy> policies, PolicyFilter filter2) {
        Predicate<SigningPolicy> predicate = p -> true;
        if (filter2.activeOnly()) {
            predicate = predicate.and(SigningPolicy::isActive);
        }
        if (filter2.validOnly()) {
            predicate = predicate.and(SigningPolicy::isValid);
        }
        if (filter2.excludeExpired()) {
            predicate = predicate.and(p -> !p.isExpired());
        }
        return policies.stream().filter(predicate).collect(Collectors.toList());
    }

    public record PolicyFilter(boolean activeOnly, boolean validOnly, boolean excludeExpired, String keyName) {
        public static PolicyFilter all() {
            return new PolicyFilter(false, false, false, null);
        }

        public static PolicyFilter onlyActive() {
            return new PolicyFilter(true, false, false, null);
        }

        public static PolicyFilter onlyValid() {
            return new PolicyFilter(false, true, false, null);
        }

        public static PolicyFilter forKey(String keyName) {
            return new PolicyFilter(false, false, false, keyName);
        }
    }

    public record PolicyStatistics(long totalCount, long activeCount, long expiredCount, long validCount) {
        public long inactiveCount() {
            return this.totalCount - this.activeCount;
        }

        public double validPercentage() {
            return this.totalCount > 0L ? (double)this.validCount / (double)this.totalCount * 100.0 : 0.0;
        }
    }
}

