/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.token;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.exceptions.IdentityException;
import xyz.tcheeric.identity.api.ports.BunkerConnectionPort;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.api.ports.TokenPort;
import xyz.tcheeric.identity.domain.AccessToken;
import xyz.tcheeric.identity.domain.SigningPolicy;

public class CreateAccessTokenUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateAccessTokenUseCase.class);
    private final TokenPort tokenPort;
    private final BunkerConnectionPort connectionPort;
    private final PolicyPort policyPort;

    public CreateAccessTokenUseCase(TokenPort tokenPort, BunkerConnectionPort connectionPort, PolicyPort policyPort) {
        this.tokenPort = Objects.requireNonNull(tokenPort, "Token port cannot be null");
        this.connectionPort = Objects.requireNonNull(connectionPort, "Connection port cannot be null");
        this.policyPort = policyPort;
    }

    public CompletableFuture<AccessToken> execute(CreateTokenRequest request) {
        Objects.requireNonNull(request, "Request cannot be null");
        LOGGER.info("create_token_started key_name={} client_name={} has_policy={} has_lifetime={}", request.keyName(), request.clientName(), request.policyId() != null, request.lifetime() != null);
        return ((CompletableFuture)((CompletableFuture)this.connectionPort.getKey(request.keyName()).thenCompose(optionalKey -> {
            if (optionalKey.isEmpty()) {
                LOGGER.warn("create_token_rejected key_name={} reason=key_not_found", (Object)request.keyName());
                return CompletableFuture.failedFuture(new IdentityException("Key not found: " + request.keyName() + ". Suggestion: Create the key first or verify the key name is correct."));
            }
            return this.validatePolicy(request);
        })).thenCompose(req -> this.createTokenInBunker((CreateTokenRequest)req))).whenComplete((token, error) -> {
            if (error != null) {
                LOGGER.error("create_token_failed key_name={} client_name={} error={}", request.keyName(), request.clientName(), error.getMessage(), error);
            } else {
                LOGGER.info("create_token_complete token_id={} key_name={} client_name={}", token.getId(), token.getKeyName(), token.getClientName());
            }
        });
    }

    private CompletableFuture<CreateTokenRequest> validatePolicy(CreateTokenRequest request) {
        if (request.policyId() == null || this.policyPort == null) {
            return CompletableFuture.completedFuture(request);
        }
        return this.policyPort.getPolicy(request.policyId()).thenApply(optionalPolicy -> {
            if (optionalPolicy.isEmpty()) {
                LOGGER.warn("create_token_rejected policy_id={} reason=policy_not_found", (Object)request.policyId());
                throw new IdentityException("Policy not found: " + request.policyId() + ". Suggestion: Verify the policy ID or create the policy first.");
            }
            if (!((SigningPolicy)optionalPolicy.get()).isValid()) {
                LOGGER.warn("create_token_rejected policy_id={} reason=policy_invalid", (Object)request.policyId());
                throw new IdentityException("Policy is not valid: " + request.policyId() + ". Suggestion: The policy may be expired or inactive. Check policy status.");
            }
            return request;
        });
    }

    private CompletableFuture<AccessToken> createTokenInBunker(CreateTokenRequest request) {
        return this.tokenPort.createToken(request.keyName(), request.clientName(), request.policyId(), request.lifetime()).exceptionally(error -> {
            throw new IdentityException("Failed to create token for '" + request.keyName() + "': " + error.getMessage() + ". Suggestion: Check bunker connectivity and verify you have permission to create tokens.", (Throwable)error);
        });
    }

    public record CreateTokenRequest(String keyName, String clientName, String policyId, Duration lifetime) {
        public CreateTokenRequest {
            Objects.requireNonNull(keyName, "Key name cannot be null");
            Objects.requireNonNull(clientName, "Client name cannot be null");
            if (keyName.trim().isEmpty()) {
                throw new IllegalArgumentException("Key name cannot be empty");
            }
            if (clientName.trim().isEmpty()) {
                throw new IllegalArgumentException("Client name cannot be empty");
            }
        }

        public CreateTokenRequest(String keyName, String clientName) {
            this(keyName, clientName, null, null);
        }

        public CreateTokenRequest(String keyName, String clientName, Duration lifetime) {
            this(keyName, clientName, null, lifetime);
        }
    }

    public record CreateTokenResult(boolean success, AccessToken token, String connectionString, String errorMessage) {
        public static CreateTokenResult success(AccessToken token) {
            Objects.requireNonNull(token, "Token cannot be null for success result");
            return new CreateTokenResult(true, token, token.getConnectionString().orElse(null), null);
        }

        public static CreateTokenResult failure(String errorMessage) {
            Objects.requireNonNull(errorMessage, "Error message cannot be null for failure result");
            return new CreateTokenResult(false, null, null, errorMessage);
        }
    }
}

