/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.token;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.TokenPort;
import xyz.tcheeric.identity.domain.AccessToken;

public class ListAccessTokensUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListAccessTokensUseCase.class);
    private final TokenPort tokenPort;

    public ListAccessTokensUseCase(TokenPort tokenPort) {
        this.tokenPort = Objects.requireNonNull(tokenPort, "Token port cannot be null");
    }

    public CompletableFuture<List<AccessToken>> execute(String keyName) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.debug("list_tokens_started key_name={}", (Object)keyName);
        return this.tokenPort.listTokens(keyName).whenComplete((tokens, error) -> {
            if (error != null) {
                LOGGER.error("list_tokens_failed key_name={} error={}", keyName, error.getMessage(), error);
            } else {
                LOGGER.debug("list_tokens_complete key_name={} count={}", (Object)keyName, (Object)tokens.size());
            }
        });
    }

    public CompletableFuture<List<AccessToken>> execute(String keyName, TokenFilter filter2) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        Objects.requireNonNull(filter2, "Filter cannot be null");
        LOGGER.debug("list_tokens_filtered key_name={} filter={}", (Object)keyName, (Object)filter2);
        return ((CompletableFuture)this.tokenPort.listTokens(keyName).thenApply(tokens -> this.applyFilter((List<AccessToken>)tokens, filter2))).whenComplete((tokens, error) -> {
            if (error != null) {
                LOGGER.error("list_tokens_filtered_failed key_name={} error={}", keyName, error.getMessage(), error);
            } else {
                LOGGER.debug("list_tokens_filtered_complete key_name={} count={}", (Object)keyName, (Object)tokens.size());
            }
        });
    }

    public CompletableFuture<Optional<AccessToken>> getById(String tokenId) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        LOGGER.debug("get_token_by_id token_id={}", (Object)tokenId);
        return this.tokenPort.getToken(tokenId).whenComplete((token, error) -> {
            if (error != null) {
                LOGGER.error("get_token_by_id_failed token_id={} error={}", tokenId, error.getMessage(), error);
            } else {
                LOGGER.debug("get_token_by_id_complete token_id={} found={}", (Object)tokenId, (Object)token.isPresent());
            }
        });
    }

    public CompletableFuture<Boolean> validate(String tokenString) {
        Objects.requireNonNull(tokenString, "Token string cannot be null");
        LOGGER.debug("validate_token token_length={}", (Object)tokenString.length());
        return this.tokenPort.validateToken(tokenString).whenComplete((valid, error) -> {
            if (error != null) {
                LOGGER.error("validate_token_failed error={}", (Object)error.getMessage(), error);
            } else {
                LOGGER.debug("validate_token_complete valid={}", valid);
            }
        });
    }

    public CompletableFuture<TokenStatistics> getStatistics(String keyName) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.debug("get_token_statistics key_name={}", (Object)keyName);
        return ((CompletableFuture)this.tokenPort.listTokens(keyName).thenApply(tokens -> {
            long total = tokens.size();
            long valid = tokens.stream().filter(AccessToken::isValid).count();
            long revoked = tokens.stream().filter(AccessToken::isRevoked).count();
            long expired = tokens.stream().filter(AccessToken::isExpired).count();
            long usageLimitReached = tokens.stream().filter(AccessToken::isUsageLimitReached).count();
            return new TokenStatistics(total, valid, revoked, expired, usageLimitReached);
        })).whenComplete((stats, error) -> {
            if (error != null) {
                LOGGER.error("get_token_statistics_failed key_name={} error={}", keyName, error.getMessage(), error);
            } else {
                LOGGER.debug("get_token_statistics_complete key_name={} total={} valid={}", keyName, stats.totalCount(), stats.validCount());
            }
        });
    }

    public CompletableFuture<List<AccessToken>> findByClientName(String keyName, String clientPattern) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        Objects.requireNonNull(clientPattern, "Client pattern cannot be null");
        LOGGER.debug("find_tokens_by_client key_name={} pattern={}", (Object)keyName, (Object)clientPattern);
        String lowerPattern = clientPattern.toLowerCase();
        return ((CompletableFuture)this.tokenPort.listTokens(keyName).thenApply(tokens -> tokens.stream().filter(t -> t.getClientName().toLowerCase().contains(lowerPattern)).collect(Collectors.toList()))).whenComplete((tokens, error) -> {
            if (error != null) {
                LOGGER.error("find_tokens_by_client_failed key_name={} pattern={} error={}", keyName, clientPattern, error.getMessage(), error);
            } else {
                LOGGER.debug("find_tokens_by_client_complete key_name={} pattern={} count={}", keyName, clientPattern, tokens.size());
            }
        });
    }

    private List<AccessToken> applyFilter(List<AccessToken> tokens, TokenFilter filter2) {
        Predicate<AccessToken> predicate = t -> true;
        if (filter2.validOnly()) {
            predicate = predicate.and(AccessToken::isValid);
        }
        if (filter2.excludeRevoked()) {
            predicate = predicate.and(t -> !t.isRevoked());
        }
        if (filter2.excludeExpired()) {
            predicate = predicate.and(t -> !t.isExpired());
        }
        if (filter2.revokedOnly()) {
            predicate = predicate.and(AccessToken::isRevoked);
        }
        if (filter2.withPolicyOnly()) {
            predicate = predicate.and(AccessToken::hasPolicy);
        }
        return tokens.stream().filter(predicate).collect(Collectors.toList());
    }

    public record TokenFilter(boolean validOnly, boolean excludeRevoked, boolean excludeExpired, boolean revokedOnly, boolean withPolicyOnly) {
        public static TokenFilter all() {
            return new TokenFilter(false, false, false, false, false);
        }

        public static TokenFilter onlyValid() {
            return new TokenFilter(true, false, false, false, false);
        }

        public static TokenFilter onlyActive() {
            return new TokenFilter(false, true, true, false, false);
        }

        public static TokenFilter onlyRevoked() {
            return new TokenFilter(false, false, false, true, false);
        }
    }

    public record TokenStatistics(long totalCount, long validCount, long revokedCount, long expiredCount, long usageLimitReachedCount) {
        public long activeCount() {
            return this.totalCount - this.revokedCount - this.expiredCount;
        }

        public double validPercentage() {
            return this.totalCount > 0L ? (double)this.validCount / (double)this.totalCount * 100.0 : 0.0;
        }
    }
}

