/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.util.Arrays;
import java.util.Optional;

public enum PaymentMethod {
    LIGHTNING("lightning", "Lightning Network"),
    ECASH("ecash", "Ecash"),
    CREDIT_CARD("credit_card", "Credit Card"),
    CASH("cash", "Cash"),
    MOBILE_MONEY("mobile_money", "Mobile Money"),
    BANK_TRANSFER("bank_transfer", "Bank Transfer"),
    BITCOIN_ONCHAIN("bitcoin_onchain", "Bitcoin (On-chain)"),
    VOUCHER("voucher", "Voucher");

    private final String code;
    private final String displayName;

    private PaymentMethod(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Optional<PaymentMethod> fromCode(String code) {
        if (code == null || code.isBlank()) {
            return Optional.empty();
        }
        String normalizedCode = code.trim().toLowerCase();
        return Arrays.stream(PaymentMethod.values()).filter(pm -> pm.code.equals(normalizedCode)).findFirst();
    }

    public static PaymentMethod requireFromCode(String code) {
        return PaymentMethod.fromCode(code).orElseThrow(() -> new IllegalArgumentException("Unknown payment method code: " + code + ". Valid codes are: " + Arrays.toString(Arrays.stream(PaymentMethod.values()).map(PaymentMethod::getCode).toArray())));
    }

    public static boolean isValidCode(String code) {
        return PaymentMethod.fromCode(code).isPresent();
    }
}

