/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.util.Optional;

public record ProfileMetadata(String name, String about, String picture, String nip05, String lud16, String banner, String website) {
    public static ProfileMetadata empty() {
        return new ProfileMetadata(null, null, null, null, null, null, null);
    }

    public static ProfileMetadata ofName(String name) {
        return new ProfileMetadata(name, null, null, null, null, null, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getAbout() {
        return Optional.ofNullable(this.about);
    }

    public Optional<String> getPicture() {
        return Optional.ofNullable(this.picture);
    }

    public Optional<String> getNip05() {
        return Optional.ofNullable(this.nip05);
    }

    public Optional<String> getLud16() {
        return Optional.ofNullable(this.lud16);
    }

    public Optional<String> getBanner() {
        return Optional.ofNullable(this.banner);
    }

    public Optional<String> getWebsite() {
        return Optional.ofNullable(this.website);
    }

    public boolean hasName() {
        return this.name != null && !this.name.isBlank();
    }

    public boolean hasNip05() {
        return this.nip05 != null && !this.nip05.isBlank();
    }

    public boolean hasLightningAddress() {
        return this.lud16 != null && !this.lud16.isBlank();
    }

    public boolean hasPicture() {
        return this.picture != null && !this.picture.isBlank();
    }

    public boolean isEmpty() {
        return !(this.hasName() || this.about != null && !this.about.isBlank() || this.hasPicture() || this.hasNip05() || this.hasLightningAddress() || this.banner != null && !this.banner.isBlank() || this.website != null && !this.website.isBlank());
    }

    public ProfileMetadata withName(String newName) {
        return new ProfileMetadata(newName, this.about, this.picture, this.nip05, this.lud16, this.banner, this.website);
    }

    public ProfileMetadata withAbout(String newAbout) {
        return new ProfileMetadata(this.name, newAbout, this.picture, this.nip05, this.lud16, this.banner, this.website);
    }

    public ProfileMetadata withPicture(String newPicture) {
        return new ProfileMetadata(this.name, this.about, newPicture, this.nip05, this.lud16, this.banner, this.website);
    }

    public ProfileMetadata withNip05(String newNip05) {
        return new ProfileMetadata(this.name, this.about, this.picture, newNip05, this.lud16, this.banner, this.website);
    }

    public ProfileMetadata withLud16(String newLud16) {
        return new ProfileMetadata(this.name, this.about, this.picture, this.nip05, newLud16, this.banner, this.website);
    }

    public ProfileMetadata withBanner(String newBanner) {
        return new ProfileMetadata(this.name, this.about, this.picture, this.nip05, this.lud16, newBanner, this.website);
    }

    public ProfileMetadata withWebsite(String newWebsite) {
        return new ProfileMetadata(this.name, this.about, this.picture, this.nip05, this.lud16, this.banner, newWebsite);
    }

    public static class Builder {
        private String name;
        private String about;
        private String picture;
        private String nip05;
        private String lud16;
        private String banner;
        private String website;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder about(String about) {
            this.about = about;
            return this;
        }

        public Builder picture(String picture) {
            this.picture = picture;
            return this;
        }

        public Builder nip05(String nip05) {
            this.nip05 = nip05;
            return this;
        }

        public Builder lud16(String lud16) {
            this.lud16 = lud16;
            return this;
        }

        public Builder banner(String banner) {
            this.banner = banner;
            return this;
        }

        public Builder website(String website) {
            this.website = website;
            return this;
        }

        public ProfileMetadata build() {
            return new ProfileMetadata(this.name, this.about, this.picture, this.nip05, this.lud16, this.banner, this.website);
        }
    }
}

