/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.util.Arrays;
import java.util.Objects;
import xyz.tcheeric.identity.domain.PrivateKey;

public class PublicKey {
    private static final int KEY_LENGTH = 32;
    private final byte[] keyBytes;

    public PublicKey(byte[] keyBytes) {
        Objects.requireNonNull(keyBytes, "Public key bytes cannot be null");
        if (keyBytes.length != 32) {
            throw new IllegalArgumentException(String.format("Public key must be exactly %d bytes, got %d", 32, keyBytes.length));
        }
        this.keyBytes = Arrays.copyOf(keyBytes, keyBytes.length);
    }

    public static PublicKey fromNostrJava(nostr.base.PublicKey nostrPublicKey) {
        Objects.requireNonNull(nostrPublicKey, "Nostr-java PublicKey cannot be null");
        return new PublicKey(nostrPublicKey.getRawData());
    }

    public nostr.base.PublicKey toNostrJava() {
        return new nostr.base.PublicKey(this.keyBytes);
    }

    public byte[] getRawBytes() {
        return Arrays.copyOf(this.keyBytes, this.keyBytes.length);
    }

    public byte[] rawData() {
        return this.getRawBytes();
    }

    public int length() {
        return this.keyBytes.length;
    }

    public static PublicKey fromHex(String hex) {
        Objects.requireNonNull(hex, "Hex string cannot be null");
        if (hex.length() != 64) {
            throw new IllegalArgumentException(String.format("Hex string must be exactly %d characters, got %d", 64, hex.length()));
        }
        return new PublicKey(PublicKey.hexToBytes(hex));
    }

    public String toHex() {
        return PublicKey.bytesToHex(this.keyBytes);
    }

    public static PublicKey fromPrivateKey(PrivateKey privateKey) {
        Objects.requireNonNull(privateKey, "Private key cannot be null");
        throw new UnsupportedOperationException("Public key derivation not yet implemented - will be added in Week 4 (crypto integration). For testing, use PublicKey constructor directly with pre-computed key bytes.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKey publicKey = (PublicKey)o;
        return Arrays.equals(this.keyBytes, publicKey.keyBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyBytes);
    }

    public String toString() {
        String hex = PublicKey.bytesToHex(this.keyBytes);
        return "PublicKey{" + hex.substring(0, Math.min(16, hex.length())) + "...}";
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            data[i2 / 2] = (byte)((Character.digit(hex.charAt(i2), 16) << 4) + Character.digit(hex.charAt(i2 + 1), 16));
        }
        return data;
    }
}

