/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.authentication;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import xyz.tcheeric.identity.api.ports.AuthenticationPort;

public class SecureRandomTokenAdapter
implements AuthenticationPort {
    private static final int TOKEN_BYTES = 24;
    private static final String TOKEN_PREFIX = "tok_";
    private final SecureRandom secureRandom;
    private final ConcurrentMap<String, String> tokenToSubject;

    public SecureRandomTokenAdapter() {
        this(new SecureRandom(), new ConcurrentHashMap<String, String>());
    }

    public SecureRandomTokenAdapter(SecureRandom secureRandom, ConcurrentMap<String, String> tokenStore) {
        this.secureRandom = secureRandom;
        this.tokenToSubject = tokenStore;
    }

    @Override
    public String generateToken(String subject) {
        if (subject == null || subject.isBlank()) {
            throw new IllegalArgumentException("subject cannot be null or blank");
        }
        byte[] randomBytes = new byte[24];
        this.secureRandom.nextBytes(randomBytes);
        String encoded = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
        String token = TOKEN_PREFIX + encoded;
        this.tokenToSubject.put(token, subject);
        return token;
    }

    @Override
    public boolean validateToken(String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        return this.tokenToSubject.containsKey(token);
    }

    @Override
    public Optional<String> getSubject(String token) {
        if (token == null || token.isEmpty()) {
            return Optional.empty();
        }
        String subject = (String)this.tokenToSubject.get(token);
        return Optional.ofNullable(subject);
    }

    public boolean revokeToken(String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        return this.tokenToSubject.remove(token) != null;
    }

    public int getActiveTokenCount() {
        return this.tokenToSubject.size();
    }

    public void clear() {
        this.tokenToSubject.clear();
    }
}

