/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.bunker;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.domain.PolicyRule;
import xyz.tcheeric.identity.domain.SigningPolicy;
import xyz.tcheeric.nsecbunker.admin.NsecBunkerAdminClient;
import xyz.tcheeric.nsecbunker.admin.policy.PolicyManager;
import xyz.tcheeric.nsecbunker.core.model.BunkerPolicy;
import xyz.tcheeric.nsecbunker.core.model.PolicyRule;

public class BunkerPolicyAdapter
implements PolicyPort {
    private static final Logger LOGGER = LoggerFactory.getLogger(BunkerPolicyAdapter.class);
    private final Supplier<NsecBunkerAdminClient> clientSupplier;

    public BunkerPolicyAdapter(Supplier<NsecBunkerAdminClient> clientSupplier) {
        this.clientSupplier = Objects.requireNonNull(clientSupplier, "Client supplier cannot be null");
    }

    @Override
    public CompletableFuture<SigningPolicy> createPolicy(SigningPolicy policy) {
        Objects.requireNonNull(policy, "Policy cannot be null");
        LOGGER.info("bunker_policy creating policy_name={}", (Object)policy.getName());
        BunkerPolicy bunkerPolicy = this.toBunkerPolicy(policy);
        return ((CompletableFuture)this.getPolicyManager().createPolicy(bunkerPolicy).thenApply(this::toSigningPolicy)).whenComplete((created, error) -> {
            if (error == null) {
                LOGGER.info("bunker_policy created policy_id={} policy_name={}", (Object)created.getId(), (Object)created.getName());
            } else {
                LOGGER.error("bunker_policy create_failed policy_name={} error={}", policy.getName(), error.getMessage(), error);
            }
        });
    }

    @Override
    public CompletableFuture<Optional<SigningPolicy>> getPolicy(String policyId) {
        Objects.requireNonNull(policyId, "Policy ID cannot be null");
        LOGGER.debug("bunker_policy fetching policy_id={}", (Object)policyId);
        return ((CompletableFuture)this.getPolicyManager().getPolicy(policyId).thenApply(bunkerPolicy -> Optional.of(this.toSigningPolicy((BunkerPolicy)bunkerPolicy)))).exceptionally(error -> {
            LOGGER.debug("bunker_policy not_found policy_id={}", (Object)policyId);
            return Optional.empty();
        });
    }

    @Override
    public CompletableFuture<List<SigningPolicy>> listPolicies() {
        LOGGER.debug("bunker_policies listing");
        return ((CompletableFuture)this.getPolicyManager().listPolicies().thenApply(policies -> policies.stream().map(this::toSigningPolicy).collect(Collectors.toList()))).whenComplete((policies, error) -> {
            if (error == null) {
                LOGGER.debug("bunker_policies listed count={}", (Object)policies.size());
            } else {
                LOGGER.error("bunker_policies list_failed error={}", (Object)error.getMessage(), error);
            }
        });
    }

    @Override
    public CompletableFuture<SigningPolicy> updatePolicy(SigningPolicy policy) {
        Objects.requireNonNull(policy, "Policy cannot be null");
        Objects.requireNonNull(policy.getId(), "Policy ID cannot be null for update");
        LOGGER.info("bunker_policy updating policy_id={} policy_name={}", (Object)policy.getId(), (Object)policy.getName());
        return ((CompletableFuture)((CompletableFuture)this.getPolicyManager().deletePolicy(policy.getId()).thenCompose(deleted -> {
            BunkerPolicy bunkerPolicy = this.toBunkerPolicy(policy);
            return this.getPolicyManager().createPolicy(bunkerPolicy);
        })).thenApply(this::toSigningPolicy)).whenComplete((updated, error) -> {
            if (error == null) {
                LOGGER.info("bunker_policy updated policy_id={} policy_name={}", (Object)updated.getId(), (Object)updated.getName());
            } else {
                LOGGER.error("bunker_policy update_failed policy_id={} error={}", policy.getId(), error.getMessage(), error);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> deletePolicy(String policyId) {
        Objects.requireNonNull(policyId, "Policy ID cannot be null");
        LOGGER.info("bunker_policy deleting policy_id={}", (Object)policyId);
        return this.getPolicyManager().deletePolicy(policyId).whenComplete((success, error) -> {
            if (error == null && success.booleanValue()) {
                LOGGER.info("bunker_policy deleted policy_id={}", (Object)policyId);
            } else if (error != null) {
                LOGGER.error("bunker_policy delete_failed policy_id={} error={}", policyId, error.getMessage(), error);
            }
        });
    }

    @Override
    public CompletableFuture<Void> attachPolicyToKey(String policyId, String keyName) {
        Objects.requireNonNull(policyId, "Policy ID cannot be null");
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.info("bunker_policy attaching policy_id={} key_name={}", (Object)policyId, (Object)keyName);
        LOGGER.warn("bunker_policy attach_policy_to_key not_fully_implemented policy_id={} key_name={}", (Object)policyId, (Object)keyName);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> detachPolicyFromKey(String policyId, String keyName) {
        Objects.requireNonNull(policyId, "Policy ID cannot be null");
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.info("bunker_policy detaching policy_id={} key_name={}", (Object)policyId, (Object)keyName);
        LOGGER.warn("bunker_policy detach_policy_from_key not_fully_implemented policy_id={} key_name={}", (Object)policyId, (Object)keyName);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<List<SigningPolicy>> listPoliciesForKey(String keyName) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.debug("bunker_policies listing_for_key key_name={}", (Object)keyName);
        LOGGER.warn("bunker_policies list_policies_for_key not_fully_implemented key_name={}", (Object)keyName);
        return this.listPolicies();
    }

    private BunkerPolicy toBunkerPolicy(SigningPolicy policy) {
        BunkerPolicy.BunkerPolicyBuilder builder = BunkerPolicy.builder().id(policy.getId()).name(policy.getName()).description(policy.getDescription().orElse(null)).createdAt(policy.getCreatedAt()).expiresAt(policy.getExpiresAt().orElse(null)).active(policy.isActive());
        for (PolicyRule domainRule : policy.getRules()) {
            builder.rule(this.toBunkerPolicyRule(domainRule));
        }
        return builder.build();
    }

    private xyz.tcheeric.nsecbunker.core.model.PolicyRule toBunkerPolicyRule(PolicyRule domainRule) {
        PolicyRule.PolicyRuleBuilder builder = xyz.tcheeric.nsecbunker.core.model.PolicyRule.builder();
        if (domainRule.isAllow()) {
            builder.type(PolicyRule.RuleType.ALLOW);
        } else {
            builder.type(PolicyRule.RuleType.DENY);
        }
        domainRule.getMethod().ifPresent(builder::method);
        domainRule.getEventKind().ifPresent(builder::eventKind);
        domainRule.getMaxUsage().ifPresent(builder::maxUsage);
        builder.currentUsage(domainRule.getCurrentUsage());
        domainRule.getDescription().ifPresent(builder::description);
        return builder.build();
    }

    private SigningPolicy toSigningPolicy(BunkerPolicy bunkerPolicy) {
        ArrayList<PolicyRule> rules = new ArrayList<PolicyRule>();
        if (bunkerPolicy.hasRules()) {
            for (xyz.tcheeric.nsecbunker.core.model.PolicyRule bunkerRule : bunkerPolicy.getRules()) {
                rules.add(this.toDomainPolicyRule(bunkerRule));
            }
        }
        return new SigningPolicy(bunkerPolicy.getId(), bunkerPolicy.getName(), bunkerPolicy.getDescription(), rules, bunkerPolicy.getCreatedAt() != null ? bunkerPolicy.getCreatedAt() : Instant.now(), bunkerPolicy.getExpiresAt(), bunkerPolicy.isActive());
    }

    private PolicyRule toDomainPolicyRule(xyz.tcheeric.nsecbunker.core.model.PolicyRule bunkerRule) {
        PolicyRule domainRule = bunkerRule.getMethod() != null ? (bunkerRule.isAllow() ? PolicyRule.allowMethod(bunkerRule.getMethod()) : PolicyRule.denyMethod(bunkerRule.getMethod())) : (bunkerRule.getEventKind() != null ? (bunkerRule.isAllow() ? PolicyRule.allowEventKind(bunkerRule.getEventKind()) : PolicyRule.denyEventKind(bunkerRule.getEventKind())) : PolicyRule.allowMethod("*"));
        if (bunkerRule.hasUsageLimit()) {
            domainRule = domainRule.withMaxUsage(bunkerRule.getMaxUsage());
        }
        if (bunkerRule.getDescription() != null) {
            domainRule = domainRule.withDescription(bunkerRule.getDescription());
        }
        return domainRule;
    }

    private PolicyManager getPolicyManager() {
        NsecBunkerAdminClient client = this.clientSupplier.get();
        if (client == null) {
            throw new IllegalStateException("Admin client not available");
        }
        return client.policyManager();
    }
}

