/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.bunker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.exceptions.IdentityException;
import xyz.tcheeric.identity.api.ports.SigningPort;
import xyz.tcheeric.identity.domain.BunkerIdentity;
import xyz.tcheeric.identity.domain.NostrEvent;
import xyz.tcheeric.identity.infrastructure.bunker.SignerPool;
import xyz.tcheeric.nsecbunker.client.signer.NsecBunkerSigner;

public class BunkerSigningAdapter
implements SigningPort,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BunkerSigningAdapter.class);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_IDLE_TIMEOUT = Duration.ofMinutes(5L);
    private static final int DEFAULT_POOL_SIZE = 10;
    private final SignerPool signerPool;

    public BunkerSigningAdapter(String clientPrivateKey) {
        this(clientPrivateKey, DEFAULT_CONNECT_TIMEOUT, DEFAULT_REQUEST_TIMEOUT);
    }

    public BunkerSigningAdapter(String clientPrivateKey, Duration connectTimeout, Duration requestTimeout) {
        Objects.requireNonNull(clientPrivateKey, "Client private key cannot be null");
        Objects.requireNonNull(connectTimeout, "Connect timeout cannot be null");
        Objects.requireNonNull(requestTimeout, "Request timeout cannot be null");
        this.signerPool = new SignerPool.Builder().clientPrivateKey(clientPrivateKey).maxSize(10).idleTimeout(DEFAULT_IDLE_TIMEOUT).connectTimeout(connectTimeout).requestTimeout(requestTimeout).build();
    }

    public BunkerSigningAdapter(SignerPool signerPool) {
        this.signerPool = Objects.requireNonNull(signerPool, "Signer pool cannot be null");
    }

    @Override
    public CompletableFuture<SigningPort.SignedEventResult> signEvent(BunkerIdentity identity, NostrEvent event) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        Objects.requireNonNull(event, "Event cannot be null");
        LOGGER.debug("signing_event_started identity={} kind={}", (Object)identity.getKeyName(), (Object)event.kind());
        return ((CompletableFuture)((CompletableFuture)this.signerPool.acquire(identity).thenCompose(signer -> {
            String eventJson = event.toJson();
            LOGGER.debug("signing_event event_json_length={}", (Object)eventJson.length());
            return signer.signEvent(eventJson);
        })).thenApply(signedEventJson -> {
            this.signerPool.release(identity);
            SigningPort.SignedEventResult result = this.parseSignedEventJson((String)signedEventJson, identity.getKeyName(), event.kind());
            LOGGER.info("signing_event_complete identity={} kind={} event_id={}", identity.getKeyName(), event.kind(), result.eventId());
            return result;
        })).exceptionally(ex -> {
            LOGGER.error("signing_event_failed identity={} error={}", identity.getKeyName(), ex.getMessage(), ex);
            throw this.wrapException("Failed to sign event", (Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<String> nip04Encrypt(BunkerIdentity identity, String recipientPubkey, String plaintext) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        Objects.requireNonNull(recipientPubkey, "Recipient pubkey cannot be null");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null");
        LOGGER.debug("nip04_encrypt_started identity={} recipient={}", (Object)identity.getKeyName(), (Object)recipientPubkey.substring(0, Math.min(16, recipientPubkey.length())));
        return ((CompletableFuture)((CompletableFuture)this.signerPool.acquire(identity).thenCompose(signer -> signer.nip04Encrypt(recipientPubkey, plaintext))).whenComplete((result, ex) -> {
            this.signerPool.release(identity);
            if (ex != null) {
                LOGGER.error("nip04_encrypt_failed identity={} error={}", (Object)identity.getKeyName(), (Object)ex.getMessage());
            } else {
                LOGGER.debug("nip04_encrypt_complete identity={}", (Object)identity.getKeyName());
            }
        })).exceptionally(ex -> {
            throw this.wrapException("Failed to encrypt with NIP-04", (Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<String> nip04Decrypt(BunkerIdentity identity, String senderPubkey, String ciphertext) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        Objects.requireNonNull(senderPubkey, "Sender pubkey cannot be null");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null");
        LOGGER.debug("nip04_decrypt_started identity={} sender={}", (Object)identity.getKeyName(), (Object)senderPubkey.substring(0, Math.min(16, senderPubkey.length())));
        return ((CompletableFuture)((CompletableFuture)this.signerPool.acquire(identity).thenCompose(signer -> signer.nip04Decrypt(senderPubkey, ciphertext))).whenComplete((result, ex) -> {
            this.signerPool.release(identity);
            if (ex != null) {
                LOGGER.error("nip04_decrypt_failed identity={} error={}", (Object)identity.getKeyName(), (Object)ex.getMessage());
            } else {
                LOGGER.debug("nip04_decrypt_complete identity={}", (Object)identity.getKeyName());
            }
        })).exceptionally(ex -> {
            throw this.wrapException("Failed to decrypt with NIP-04", (Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<String> nip44Encrypt(BunkerIdentity identity, String recipientPubkey, String plaintext) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        Objects.requireNonNull(recipientPubkey, "Recipient pubkey cannot be null");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null");
        LOGGER.debug("nip44_encrypt_started identity={} recipient={}", (Object)identity.getKeyName(), (Object)recipientPubkey.substring(0, Math.min(16, recipientPubkey.length())));
        return ((CompletableFuture)((CompletableFuture)this.signerPool.acquire(identity).thenCompose(signer -> signer.nip44Encrypt(recipientPubkey, plaintext))).whenComplete((result, ex) -> {
            this.signerPool.release(identity);
            if (ex != null) {
                LOGGER.error("nip44_encrypt_failed identity={} error={}", (Object)identity.getKeyName(), (Object)ex.getMessage());
            } else {
                LOGGER.debug("nip44_encrypt_complete identity={}", (Object)identity.getKeyName());
            }
        })).exceptionally(ex -> {
            throw this.wrapException("Failed to encrypt with NIP-44", (Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<String> nip44Decrypt(BunkerIdentity identity, String senderPubkey, String ciphertext) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        Objects.requireNonNull(senderPubkey, "Sender pubkey cannot be null");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null");
        LOGGER.debug("nip44_decrypt_started identity={} sender={}", (Object)identity.getKeyName(), (Object)senderPubkey.substring(0, Math.min(16, senderPubkey.length())));
        return ((CompletableFuture)((CompletableFuture)this.signerPool.acquire(identity).thenCompose(signer -> signer.nip44Decrypt(senderPubkey, ciphertext))).whenComplete((result, ex) -> {
            this.signerPool.release(identity);
            if (ex != null) {
                LOGGER.error("nip44_decrypt_failed identity={} error={}", (Object)identity.getKeyName(), (Object)ex.getMessage());
            } else {
                LOGGER.debug("nip44_decrypt_complete identity={}", (Object)identity.getKeyName());
            }
        })).exceptionally(ex -> {
            throw this.wrapException("Failed to decrypt with NIP-44", (Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<String> getPublicKey(BunkerIdentity identity) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        LOGGER.debug("get_public_key_started identity={}", (Object)identity.getKeyName());
        return ((CompletableFuture)((CompletableFuture)this.signerPool.acquire(identity).thenCompose(NsecBunkerSigner::getPublicKey)).whenComplete((result, ex) -> {
            this.signerPool.release(identity);
            if (ex != null) {
                LOGGER.error("get_public_key_failed identity={} error={}", (Object)identity.getKeyName(), (Object)ex.getMessage());
            } else {
                LOGGER.debug("get_public_key_complete identity={} pubkey={}", (Object)identity.getKeyName(), (Object)result.substring(0, Math.min(16, result.length())));
            }
        })).exceptionally(ex -> {
            throw this.wrapException("Failed to get public key", (Throwable)ex);
        });
    }

    @Override
    public CompletableFuture<String> ping(BunkerIdentity identity) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        LOGGER.debug("ping_started identity={}", (Object)identity.getKeyName());
        return ((CompletableFuture)((CompletableFuture)this.signerPool.acquire(identity).thenCompose(NsecBunkerSigner::ping)).whenComplete((result, ex) -> {
            this.signerPool.release(identity);
            if (ex != null) {
                LOGGER.warn("ping_failed identity={} error={}", (Object)identity.getKeyName(), (Object)ex.getMessage());
            } else {
                LOGGER.debug("ping_complete identity={} response={}", (Object)identity.getKeyName(), result);
            }
        })).exceptionally(ex -> {
            throw this.wrapException("Ping failed", (Throwable)ex);
        });
    }

    public void removeSigner(BunkerIdentity identity) {
        Objects.requireNonNull(identity, "Identity cannot be null");
        this.signerPool.remove(identity);
    }

    public int getPoolSize() {
        return this.signerPool.size();
    }

    public boolean hasPooledSigner(BunkerIdentity identity) {
        return this.signerPool.contains(identity);
    }

    public SignerPool.PoolStats getPoolStats() {
        return this.signerPool.getStats();
    }

    private SigningPort.SignedEventResult parseSignedEventJson(String signedEventJson, String keyName, int kind) {
        try {
            String signature;
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(signedEventJson);
            String eventId = node.has("id") ? node.get("id").asText() : null;
            String string = signature = node.has("sig") ? node.get("sig").asText() : null;
            if (eventId == null || signature == null) {
                LOGGER.warn("signed_event_parse_incomplete id={} sig={} response={}", eventId != null, signature != null, signedEventJson.substring(0, Math.min(100, signedEventJson.length())));
            }
            return new SigningPort.SignedEventResult(eventId, signature);
        }
        catch (Exception e) {
            LOGGER.error("signed_event_parse_failed identity={} kind={} error={}", keyName, kind, e.getMessage());
            return new SigningPort.SignedEventResult(null, signedEventJson);
        }
    }

    private RuntimeException wrapException(String message, Throwable cause) {
        Throwable actual = cause;
        if (cause instanceof CompletionException) {
            actual = cause.getCause();
        }
        return new IdentityException(message + ": " + actual.getMessage(), actual);
    }

    @Override
    public void close() {
        LOGGER.info("bunker_signing_adapter_closing");
        this.signerPool.close();
        LOGGER.info("bunker_signing_adapter_closed");
    }
}

