/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.bunker;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.TokenPort;
import xyz.tcheeric.nsecbunker.admin.NsecBunkerAdminClient;
import xyz.tcheeric.nsecbunker.admin.token.TokenManager;
import xyz.tcheeric.nsecbunker.core.model.AccessToken;

public class BunkerTokenAdapter
implements TokenPort {
    private static final Logger LOGGER = LoggerFactory.getLogger(BunkerTokenAdapter.class);
    private final Supplier<NsecBunkerAdminClient> clientSupplier;

    public BunkerTokenAdapter(Supplier<NsecBunkerAdminClient> clientSupplier) {
        this.clientSupplier = Objects.requireNonNull(clientSupplier, "Client supplier cannot be null");
    }

    @Override
    public CompletableFuture<xyz.tcheeric.identity.domain.AccessToken> createToken(String keyName, String clientName, String policyId, Duration lifetime) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        Objects.requireNonNull(clientName, "Client name cannot be null");
        LOGGER.info("bunker_token creating key_name={} client_name={} has_policy={} has_lifetime={}", keyName, clientName, policyId != null, lifetime != null);
        return ((CompletableFuture)this.getTokenManager().createToken(keyName, clientName, policyId, lifetime).thenApply(this::toDomainToken)).whenComplete((token, error) -> {
            if (error == null) {
                LOGGER.info("bunker_token created token_id={} key_name={} client_name={}", token.getId(), keyName, clientName);
            } else {
                LOGGER.error("bunker_token create_failed key_name={} client_name={} error={}", keyName, clientName, error.getMessage(), error);
            }
        });
    }

    @Override
    public CompletableFuture<Optional<xyz.tcheeric.identity.domain.AccessToken>> getToken(String tokenId) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        LOGGER.debug("bunker_token fetching token_id={}", (Object)tokenId);
        return ((CompletableFuture)this.getTokenManager().getToken(tokenId).thenApply(bunkerToken -> Optional.of(this.toDomainToken((AccessToken)bunkerToken)))).exceptionally(error -> {
            LOGGER.debug("bunker_token not_found token_id={}", (Object)tokenId);
            return Optional.empty();
        });
    }

    @Override
    public CompletableFuture<List<xyz.tcheeric.identity.domain.AccessToken>> listTokens(String keyName) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.debug("bunker_tokens listing key_name={}", (Object)keyName);
        return ((CompletableFuture)this.getTokenManager().listTokens(keyName).thenApply(tokens -> tokens.stream().map(this::toDomainToken).collect(Collectors.toList()))).whenComplete((tokens, error) -> {
            if (error == null) {
                LOGGER.debug("bunker_tokens listed key_name={} count={}", (Object)keyName, (Object)tokens.size());
            } else {
                LOGGER.error("bunker_tokens list_failed key_name={} error={}", keyName, error.getMessage(), error);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> revokeToken(String tokenId) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        LOGGER.info("bunker_token revoking token_id={}", (Object)tokenId);
        return this.getTokenManager().revokeToken(tokenId).whenComplete((success, error) -> {
            if (error == null && success.booleanValue()) {
                LOGGER.info("bunker_token revoked token_id={}", (Object)tokenId);
            } else if (error != null) {
                LOGGER.error("bunker_token revoke_failed token_id={} error={}", tokenId, error.getMessage(), error);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> validateToken(String tokenString) {
        Objects.requireNonNull(tokenString, "Token string cannot be null");
        LOGGER.debug("bunker_token validating token_string_length={}", (Object)tokenString.length());
        return this.getTokenManager().validateToken(tokenString).whenComplete((valid, error) -> {
            if (error == null) {
                LOGGER.debug("bunker_token validated valid={}", valid);
            } else {
                LOGGER.warn("bunker_token validate_failed error={}", (Object)error.getMessage());
            }
        });
    }

    @Override
    public CompletableFuture<Optional<TokenPort.TokenStats>> getTokenStats(String tokenId) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        LOGGER.debug("bunker_token_stats fetching token_id={}", (Object)tokenId);
        return ((CompletableFuture)this.getTokenManager().getToken(tokenId).thenApply(bunkerToken -> {
            if (bunkerToken == null) {
                return Optional.empty();
            }
            Long timeUntilExpiry = null;
            if (bunkerToken.getExpiresAt() != null) {
                Duration remaining = Duration.between(Instant.now(), bunkerToken.getExpiresAt());
                timeUntilExpiry = Math.max(0L, remaining.toMillis());
            }
            Long remainingUsage = null;
            if (bunkerToken.getMaxUsage() != null) {
                remainingUsage = Math.max(0L, bunkerToken.getMaxUsage() - bunkerToken.getUsageCount());
            }
            long lastUsedAt = bunkerToken.getLastUsedAt() != null ? bunkerToken.getLastUsedAt().toEpochMilli() : 0L;
            return Optional.of(new TokenPort.TokenStats(bunkerToken.getUsageCount(), lastUsedAt, remainingUsage, timeUntilExpiry));
        })).exceptionally(error -> {
            LOGGER.debug("bunker_token_stats not_found token_id={}", (Object)tokenId);
            return Optional.empty();
        });
    }

    private xyz.tcheeric.identity.domain.AccessToken toDomainToken(AccessToken bunkerToken) {
        return new xyz.tcheeric.identity.domain.AccessToken(bunkerToken.getId(), bunkerToken.getToken(), bunkerToken.getKeyName(), bunkerToken.getKeyNpub(), bunkerToken.getClientName(), bunkerToken.getPolicyId(), bunkerToken.getPolicyName(), bunkerToken.getRelay(), bunkerToken.getCreatedAt() != null ? bunkerToken.getCreatedAt() : Instant.now(), bunkerToken.getExpiresAt(), bunkerToken.getLastUsedAt(), bunkerToken.getUsageCount(), bunkerToken.getMaxUsage(), bunkerToken.isRevoked());
    }

    private TokenManager getTokenManager() {
        NsecBunkerAdminClient client = this.clientSupplier.get();
        if (client == null) {
            throw new IllegalStateException("Admin client not available");
        }
        return client.tokenManager();
    }
}

