/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.infrastructure.crypto;

import nostr.base.PrivateKey;
import nostr.base.PublicKey;
import nostr.crypto.schnorr.Schnorr;

public class KeyGenerator {
    public static PrivateKey generatePrivateKey() {
        return PrivateKey.generateRandomPrivKey();
    }

    public static PublicKey derivePublicKey(PrivateKey privateKey) {
        byte[] pubKeyBytes = Schnorr.genPubKey(privateKey.getRawData());
        return new PublicKey(pubKeyBytes);
    }

    public static KeyPair generateKeyPair() {
        PrivateKey privateKey = KeyGenerator.generatePrivateKey();
        PublicKey publicKey = KeyGenerator.derivePublicKey(privateKey);
        return new KeyPair(privateKey, publicKey);
    }

    public record KeyPair(PrivateKey privateKey, PublicKey publicKey) {
    }
}

