/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.contracts;

import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.messaging.contracts.IdentityMessage;

public interface MessageClient {
    public <T extends IdentityMessage> T sendSync(IdentityMessage var1, Class<T> var2);

    public <T extends IdentityMessage> CompletableFuture<T> sendAsync(IdentityMessage var1, Class<T> var2);

    public static class MessageTimeoutException
    extends MessageClientException {
        public MessageTimeoutException(String message) {
            super(message);
        }
    }

    public static class MessageHandlerException
    extends MessageClientException {
        public MessageHandlerException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class MessageSendException
    extends MessageClientException {
        public MessageSendException(String message) {
            super(message);
        }

        public MessageSendException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class MessageClientException
    extends RuntimeException {
        public MessageClientException(String message) {
            super(message);
        }

        public MessageClientException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

