/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.contracts;

import xyz.tcheeric.messaging.contracts.IdentityMessage;
import xyz.tcheeric.messaging.contracts.MessageHandler;

public interface MessageServer {
    public <REQ extends IdentityMessage, RES extends IdentityMessage> void subscribe(MessageHandler<REQ, RES> var1);

    public <REQ extends IdentityMessage, RES extends IdentityMessage> void unsubscribe(MessageHandler<REQ, RES> var1);

    public static class HandlerAlreadyRegisteredException
    extends RuntimeException {
        private final Class<? extends IdentityMessage> messageType;

        public HandlerAlreadyRegisteredException(Class<? extends IdentityMessage> messageType) {
            super("Handler already registered for message type: " + messageType.getName());
            this.messageType = messageType;
        }

        public Class<? extends IdentityMessage> getMessageType() {
            return this.messageType;
        }
    }
}

