/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.messages;

import java.util.Objects;
import xyz.tcheeric.messaging.contracts.IdentityMessage;

public record EncryptMessageRequest(String requestId, String authToken, String plaintext, String recipientPubkey) implements IdentityMessage
{
    public EncryptMessageRequest {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        Objects.requireNonNull(authToken, "authToken cannot be null");
        Objects.requireNonNull(plaintext, "plaintext cannot be null");
        Objects.requireNonNull(recipientPubkey, "recipientPubkey cannot be null");
        if (requestId.isBlank()) {
            throw new IllegalArgumentException("requestId cannot be blank");
        }
        if (authToken.isBlank()) {
            throw new IllegalArgumentException("authToken cannot be blank");
        }
        if (recipientPubkey.isBlank()) {
            throw new IllegalArgumentException("recipientPubkey cannot be blank");
        }
    }

    public static EncryptMessageRequest create(String requestId, String authToken, String plaintext, String recipientPubkey) {
        return new EncryptMessageRequest(requestId, authToken, plaintext, recipientPubkey);
    }
}

