/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.messaging.messages;

import java.util.Objects;
import xyz.tcheeric.messaging.contracts.IdentityMessage;

public record PluginRegistrationResponse(String requestId, boolean success, String errorMessage, String authToken) implements IdentityMessage
{
    public PluginRegistrationResponse {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        if (requestId.isBlank()) {
            throw new IllegalArgumentException("requestId cannot be blank");
        }
        if (success && (authToken == null || authToken.isBlank())) {
            throw new IllegalArgumentException("authToken must be provided when success is true");
        }
        if (!success && (errorMessage == null || errorMessage.isBlank())) {
            throw new IllegalArgumentException("errorMessage should be provided when success is false");
        }
    }

    public static PluginRegistrationResponse success(String requestId, String authToken) {
        return new PluginRegistrationResponse(requestId, true, null, authToken);
    }

    public static PluginRegistrationResponse failure(String requestId, String errorMessage) {
        return new PluginRegistrationResponse(requestId, false, errorMessage, null);
    }
}

