/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.admin;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import nostr.crypto.bech32.Bech32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.admin.AdminException;
import xyz.tcheeric.nsecbunker.admin.NsecBunkerAdminClient;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;

public class AdminAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(AdminAuthenticator.class);
    private final NsecBunkerAdminClient client;

    public AdminAuthenticator(NsecBunkerAdminClient client) {
        this.client = client;
    }

    public CompletableFuture<Boolean> validateAdminAccess() {
        return this.validateAdminAccess(null);
    }

    public CompletableFuture<Boolean> validateAdminAccess(List<String> permissions) {
        String adminPubkey = this.client.getCommunicationIdentity().getPublicKey().toString();
        log.info("Validating admin access for pubkey: {}", (Object)adminPubkey);
        Nip46Request connectRequest = Nip46Request.connect(adminPubkey, this.client.getConfig().getSecret());
        return ((CompletableFuture)this.client.sendRequest(connectRequest).thenApply(response -> {
            if (response.isError()) {
                log.warn("Admin access denied: {}", (Object)response.getError());
                return false;
            }
            String result = response.getResult();
            if ("ack".equalsIgnoreCase(result)) {
                log.info("Admin access granted");
                return true;
            }
            log.warn("Unexpected connect response: {}", (Object)result);
            return false;
        })).exceptionally(ex -> {
            log.error("Failed to validate admin access: {}", (Object)ex.getMessage());
            return false;
        });
    }

    public boolean validateAdminAccessSync(int timeoutSeconds) {
        try {
            Boolean result = this.validateAdminAccess().get(timeoutSeconds, TimeUnit.SECONDS);
            return Boolean.TRUE.equals(result);
        }
        catch (Exception e) {
            throw new AdminException("Admin authentication failed: " + e.getMessage(), e);
        }
    }

    public String getAdminPublicKeyHex() {
        return this.client.getCommunicationIdentity().getPublicKey().toString();
    }

    public boolean isUsingEphemeralKey() {
        return this.client.getConfig().isUseEphemeralKey();
    }

    public boolean verifyAdminPubkey(String expectedPubkey) {
        String actualPubkey = this.getAdminPublicKeyHex();
        if (expectedPubkey.startsWith("npub1")) {
            try {
                expectedPubkey = Bech32.fromBech32(expectedPubkey);
            }
            catch (Exception e) {
                log.warn("Failed to decode npub: {}", (Object)e.getMessage());
                return false;
            }
        }
        return actualPubkey.equalsIgnoreCase(expectedPubkey);
    }

    public CompletableFuture<Long> ping() {
        long startTime = System.currentTimeMillis();
        return this.client.ping().thenApply(result -> System.currentTimeMillis() - startTime);
    }

    public long pingSync(int timeoutSeconds) {
        try {
            return this.ping().get(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new AdminException("Ping failed: " + e.getMessage(), e);
        }
    }
}

