/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.admin;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AdminConfig {
    private final String bunkerPubkey;
    private final String adminPrivateKey;
    private final List<String> relays;
    private final String secret;
    private final Duration connectTimeout;
    private final Duration requestTimeout;
    private final boolean autoReconnect;
    private final int maxReconnectAttempts;
    private final Duration reconnectDelay;
    private final Duration maxReconnectDelay;
    private final boolean useEphemeralKey;

    public void validate() {
        if (this.bunkerPubkey == null || this.bunkerPubkey.isBlank()) {
            throw new IllegalStateException("Bunker public key is required");
        }
        if (this.adminPrivateKey == null || this.adminPrivateKey.isBlank()) {
            throw new IllegalStateException("Admin private key is required");
        }
        if (this.relays == null || this.relays.isEmpty()) {
            throw new IllegalStateException("At least one relay URL is required");
        }
        for (String relay : this.relays) {
            if (relay.startsWith("wss://") || relay.startsWith("ws://")) continue;
            throw new IllegalStateException("Invalid relay URL: " + relay);
        }
    }

    public static AdminConfigBuilder builder() {
        return new AdminConfigBuilder();
    }

    public static AdminConfig fromConnectionString(String connectionString, String adminPrivateKey) {
        String pubkey;
        Objects.requireNonNull(connectionString, "Connection string must not be null");
        Objects.requireNonNull(adminPrivateKey, "Admin private key must not be null");
        if (!connectionString.startsWith("bunker://")) {
            throw new IllegalArgumentException("Invalid connection string: must start with bunker://");
        }
        String remainder = connectionString.substring(9);
        int queryIndex = remainder.indexOf(63);
        String query = null;
        if (queryIndex == -1) {
            pubkey = remainder;
        } else {
            pubkey = remainder.substring(0, queryIndex);
            query = remainder.substring(queryIndex + 1);
        }
        AdminConfigBuilder builder = AdminConfig.builder().bunkerPubkey(pubkey).adminPrivateKey(adminPrivateKey);
        if (query != null) {
            String[] params = query.split("&");
            ArrayList<String> relayList = new ArrayList<String>();
            block8: for (String param : params) {
                int eqIndex = param.indexOf(61);
                if (eqIndex == -1) continue;
                String key = param.substring(0, eqIndex);
                String value = URLDecoder.decode(param.substring(eqIndex + 1), StandardCharsets.UTF_8);
                switch (key) {
                    case "relay": {
                        relayList.add(value);
                        continue block8;
                    }
                    case "secret": {
                        builder.secret(value);
                    }
                }
            }
            if (!relayList.isEmpty()) {
                builder.relays(relayList);
            }
        }
        return builder.build();
    }

    private static List<String> $default$relays() {
        return List.of();
    }

    private static Duration $default$connectTimeout() {
        return Duration.ofSeconds(30L);
    }

    private static Duration $default$requestTimeout() {
        return Duration.ofSeconds(60L);
    }

    private static boolean $default$autoReconnect() {
        return true;
    }

    private static int $default$maxReconnectAttempts() {
        return 5;
    }

    private static Duration $default$reconnectDelay() {
        return Duration.ofSeconds(1L);
    }

    private static Duration $default$maxReconnectDelay() {
        return Duration.ofSeconds(30L);
    }

    private static boolean $default$useEphemeralKey() {
        return true;
    }

    AdminConfig(String bunkerPubkey, String adminPrivateKey, List<String> relays, String secret, Duration connectTimeout, Duration requestTimeout, boolean autoReconnect, int maxReconnectAttempts, Duration reconnectDelay, Duration maxReconnectDelay, boolean useEphemeralKey) {
        this.bunkerPubkey = bunkerPubkey;
        this.adminPrivateKey = adminPrivateKey;
        this.relays = relays;
        this.secret = secret;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.autoReconnect = autoReconnect;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.reconnectDelay = reconnectDelay;
        this.maxReconnectDelay = maxReconnectDelay;
        this.useEphemeralKey = useEphemeralKey;
    }

    public AdminConfigBuilder toBuilder() {
        return new AdminConfigBuilder().bunkerPubkey(this.bunkerPubkey).adminPrivateKey(this.adminPrivateKey).relays(this.relays).secret(this.secret).connectTimeout(this.connectTimeout).requestTimeout(this.requestTimeout).autoReconnect(this.autoReconnect).maxReconnectAttempts(this.maxReconnectAttempts).reconnectDelay(this.reconnectDelay).maxReconnectDelay(this.maxReconnectDelay).useEphemeralKey(this.useEphemeralKey);
    }

    public String getBunkerPubkey() {
        return this.bunkerPubkey;
    }

    public String getAdminPrivateKey() {
        return this.adminPrivateKey;
    }

    public List<String> getRelays() {
        return this.relays;
    }

    public String getSecret() {
        return this.secret;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public Duration getReconnectDelay() {
        return this.reconnectDelay;
    }

    public Duration getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public boolean isUseEphemeralKey() {
        return this.useEphemeralKey;
    }

    public String toString() {
        return "AdminConfig(bunkerPubkey=" + this.getBunkerPubkey() + ", relays=" + String.valueOf(this.getRelays()) + ", secret=" + this.getSecret() + ", connectTimeout=" + String.valueOf(this.getConnectTimeout()) + ", requestTimeout=" + String.valueOf(this.getRequestTimeout()) + ", autoReconnect=" + this.isAutoReconnect() + ", maxReconnectAttempts=" + this.getMaxReconnectAttempts() + ", reconnectDelay=" + String.valueOf(this.getReconnectDelay()) + ", maxReconnectDelay=" + String.valueOf(this.getMaxReconnectDelay()) + ", useEphemeralKey=" + this.isUseEphemeralKey() + ")";
    }

    public static class AdminConfigBuilder {
        private String bunkerPubkey;
        private String adminPrivateKey;
        private boolean relays$set;
        private List<String> relays$value;
        private String secret;
        private boolean connectTimeout$set;
        private Duration connectTimeout$value;
        private boolean requestTimeout$set;
        private Duration requestTimeout$value;
        private boolean autoReconnect$set;
        private boolean autoReconnect$value;
        private boolean maxReconnectAttempts$set;
        private int maxReconnectAttempts$value;
        private boolean reconnectDelay$set;
        private Duration reconnectDelay$value;
        private boolean maxReconnectDelay$set;
        private Duration maxReconnectDelay$value;
        private boolean useEphemeralKey$set;
        private boolean useEphemeralKey$value;

        AdminConfigBuilder() {
        }

        public AdminConfigBuilder bunkerPubkey(String bunkerPubkey) {
            this.bunkerPubkey = bunkerPubkey;
            return this;
        }

        public AdminConfigBuilder adminPrivateKey(String adminPrivateKey) {
            this.adminPrivateKey = adminPrivateKey;
            return this;
        }

        public AdminConfigBuilder relays(List<String> relays) {
            this.relays$value = relays;
            this.relays$set = true;
            return this;
        }

        public AdminConfigBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public AdminConfigBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        public AdminConfigBuilder requestTimeout(Duration requestTimeout) {
            this.requestTimeout$value = requestTimeout;
            this.requestTimeout$set = true;
            return this;
        }

        public AdminConfigBuilder autoReconnect(boolean autoReconnect) {
            this.autoReconnect$value = autoReconnect;
            this.autoReconnect$set = true;
            return this;
        }

        public AdminConfigBuilder maxReconnectAttempts(int maxReconnectAttempts) {
            this.maxReconnectAttempts$value = maxReconnectAttempts;
            this.maxReconnectAttempts$set = true;
            return this;
        }

        public AdminConfigBuilder reconnectDelay(Duration reconnectDelay) {
            this.reconnectDelay$value = reconnectDelay;
            this.reconnectDelay$set = true;
            return this;
        }

        public AdminConfigBuilder maxReconnectDelay(Duration maxReconnectDelay) {
            this.maxReconnectDelay$value = maxReconnectDelay;
            this.maxReconnectDelay$set = true;
            return this;
        }

        public AdminConfigBuilder useEphemeralKey(boolean useEphemeralKey) {
            this.useEphemeralKey$value = useEphemeralKey;
            this.useEphemeralKey$set = true;
            return this;
        }

        public AdminConfig build() {
            List<String> relays$value = this.relays$value;
            if (!this.relays$set) {
                relays$value = AdminConfig.$default$relays();
            }
            Duration connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = AdminConfig.$default$connectTimeout();
            }
            Duration requestTimeout$value = this.requestTimeout$value;
            if (!this.requestTimeout$set) {
                requestTimeout$value = AdminConfig.$default$requestTimeout();
            }
            boolean autoReconnect$value = this.autoReconnect$value;
            if (!this.autoReconnect$set) {
                autoReconnect$value = AdminConfig.$default$autoReconnect();
            }
            int maxReconnectAttempts$value = this.maxReconnectAttempts$value;
            if (!this.maxReconnectAttempts$set) {
                maxReconnectAttempts$value = AdminConfig.$default$maxReconnectAttempts();
            }
            Duration reconnectDelay$value = this.reconnectDelay$value;
            if (!this.reconnectDelay$set) {
                reconnectDelay$value = AdminConfig.$default$reconnectDelay();
            }
            Duration maxReconnectDelay$value = this.maxReconnectDelay$value;
            if (!this.maxReconnectDelay$set) {
                maxReconnectDelay$value = AdminConfig.$default$maxReconnectDelay();
            }
            boolean useEphemeralKey$value = this.useEphemeralKey$value;
            if (!this.useEphemeralKey$set) {
                useEphemeralKey$value = AdminConfig.$default$useEphemeralKey();
            }
            return new AdminConfig(this.bunkerPubkey, this.adminPrivateKey, relays$value, this.secret, connectTimeout$value, requestTimeout$value, autoReconnect$value, maxReconnectAttempts$value, reconnectDelay$value, maxReconnectDelay$value, useEphemeralKey$value);
        }

        public String toString() {
            return "AdminConfig.AdminConfigBuilder(bunkerPubkey=" + this.bunkerPubkey + ", adminPrivateKey=" + this.adminPrivateKey + ", relays$value=" + String.valueOf(this.relays$value) + ", secret=" + this.secret + ", connectTimeout$value=" + String.valueOf(this.connectTimeout$value) + ", requestTimeout$value=" + String.valueOf(this.requestTimeout$value) + ", autoReconnect$value=" + this.autoReconnect$value + ", maxReconnectAttempts$value=" + this.maxReconnectAttempts$value + ", reconnectDelay$value=" + String.valueOf(this.reconnectDelay$value) + ", maxReconnectDelay$value=" + String.valueOf(this.maxReconnectDelay$value) + ", useEphemeralKey$value=" + this.useEphemeralKey$value + ")";
        }
    }
}

