/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.admin.policy;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import xyz.tcheeric.nsecbunker.core.model.BunkerPolicy;
import xyz.tcheeric.nsecbunker.core.model.PolicyRule;

public final class PolicyBuilder {
    private final String name;
    private String description;
    private Instant expiresAt;
    private boolean active = true;
    private final List<PolicyRule> rules = new ArrayList<PolicyRule>();

    private PolicyBuilder(String name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
    }

    public static PolicyBuilder withName(String name) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Policy name must not be blank");
        }
        return new PolicyBuilder(name);
    }

    public PolicyBuilder addRule(PolicyRule rule) {
        if (rule != null) {
            this.rules.add(rule);
        }
        return this;
    }

    public PolicyBuilder allowMethod(String method) {
        return this.addRule(PolicyRule.allowMethod(method));
    }

    public PolicyBuilder denyMethod(String method) {
        return this.addRule(PolicyRule.denyMethod(method));
    }

    public PolicyBuilder allowEventKind(int eventKind) {
        return this.addRule(PolicyRule.allowEventKind(eventKind));
    }

    public PolicyBuilder denyEventKind(int eventKind) {
        return this.addRule(PolicyRule.denyEventKind(eventKind));
    }

    public PolicyBuilder allowMethodWithUsage(String method, long maxUsage) {
        PolicyRule rule = PolicyRule.builder().type(PolicyRule.RuleType.ALLOW).method(method).maxUsage(maxUsage).build();
        return this.addRule(rule);
    }

    public PolicyBuilder allowEventKindWithUsage(int eventKind, long maxUsage) {
        PolicyRule rule = PolicyRule.builder().type(PolicyRule.RuleType.ALLOW).eventKind(eventKind).maxUsage(maxUsage).build();
        return this.addRule(rule);
    }

    public PolicyBuilder inactive() {
        this.active = false;
        return this;
    }

    public PolicyBuilder description(String description) {
        this.description = description;
        return this;
    }

    public PolicyBuilder expiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    public PolicyBuilder expiresIn(Duration duration) {
        if (duration != null) {
            this.expiresAt = Instant.now().plus(duration);
        }
        return this;
    }

    public BunkerPolicy build() {
        return BunkerPolicy.builder().name(this.name).description(this.description).expiresAt(this.expiresAt).active(this.active).rules(this.rules.isEmpty() ? Collections.emptyList() : List.copyOf(this.rules)).build();
    }
}

