/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.client.request;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.client.request.RequestQueue;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Response;

public final class RequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(RequestExecutor.class);
    private final RequestQueue queue;
    private final Function<Nip46Request, CompletableFuture<Nip46Response>> transport;
    private final int maxRetries;
    private final Duration retryDelay;
    private final Duration timeout;
    private final Executor scheduler;

    public RequestExecutor(RequestQueue queue, Function<Nip46Request, CompletableFuture<Nip46Response>> transport, Config config) {
        this.queue = Objects.requireNonNull(queue, "queue must not be null");
        this.transport = Objects.requireNonNull(transport, "transport must not be null");
        Config cfg = config != null ? config : Config.builder().build();
        this.maxRetries = cfg.maxRetries;
        this.retryDelay = cfg.retryDelay;
        this.timeout = cfg.timeout;
        this.scheduler = cfg.scheduler;
    }

    public CompletableFuture<Nip46Response> execute(Nip46Request request) {
        CompletableFuture<Nip46Response> future = this.queue.register(request, this.timeout);
        AtomicInteger attempts = new AtomicInteger(0);
        this.sendWithRetry(request, future, attempts);
        return future;
    }

    public void cancelAll() {
        this.queue.cancelAll();
    }

    private void sendWithRetry(Nip46Request request, CompletableFuture<Nip46Response> future, AtomicInteger attempts) {
        if (future.isDone()) {
            return;
        }
        int currentAttempt = attempts.incrementAndGet();
        this.transport.apply(request).whenCompleteAsync((response, error) -> {
            if (future.isDone()) {
                return;
            }
            if (error != null) {
                if (currentAttempt <= this.maxRetries) {
                    this.scheduleRetry(request, future, attempts);
                } else {
                    future.completeExceptionally((Throwable)error);
                }
                return;
            }
            this.queue.complete((Nip46Response)response);
        });
    }

    private void scheduleRetry(Nip46Request request, CompletableFuture<Nip46Response> future, AtomicInteger attempts) {
        CompletableFuture.runAsync(() -> this.sendWithRetry(request, future, attempts), CompletableFuture.delayedExecutor(this.retryDelay.toMillis(), TimeUnit.MILLISECONDS, this.scheduler));
    }

    public static final class Config {
        private final int maxRetries;
        private final Duration retryDelay;
        private final Duration timeout;
        private final Executor scheduler;

        private static int $default$maxRetries() {
            return 2;
        }

        private static Duration $default$retryDelay() {
            return Duration.ofMillis(100L);
        }

        private static Duration $default$timeout() {
            return Duration.ofSeconds(30L);
        }

        private static Executor $default$scheduler() {
            return Executors.newSingleThreadExecutor();
        }

        Config(int maxRetries, Duration retryDelay, Duration timeout2, Executor scheduler) {
            this.maxRetries = maxRetries;
            this.retryDelay = retryDelay;
            this.timeout = timeout2;
            this.scheduler = scheduler;
        }

        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public Duration getRetryDelay() {
            return this.retryDelay;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Executor getScheduler() {
            return this.scheduler;
        }

        public static class ConfigBuilder {
            private boolean maxRetries$set;
            private int maxRetries$value;
            private boolean retryDelay$set;
            private Duration retryDelay$value;
            private boolean timeout$set;
            private Duration timeout$value;
            private boolean scheduler$set;
            private Executor scheduler$value;

            ConfigBuilder() {
            }

            public ConfigBuilder maxRetries(int maxRetries) {
                this.maxRetries$value = maxRetries;
                this.maxRetries$set = true;
                return this;
            }

            public ConfigBuilder retryDelay(Duration retryDelay) {
                this.retryDelay$value = retryDelay;
                this.retryDelay$set = true;
                return this;
            }

            public ConfigBuilder timeout(Duration timeout2) {
                this.timeout$value = timeout2;
                this.timeout$set = true;
                return this;
            }

            public ConfigBuilder scheduler(Executor scheduler) {
                this.scheduler$value = scheduler;
                this.scheduler$set = true;
                return this;
            }

            public Config build() {
                int maxRetries$value = this.maxRetries$value;
                if (!this.maxRetries$set) {
                    maxRetries$value = Config.$default$maxRetries();
                }
                Duration retryDelay$value = this.retryDelay$value;
                if (!this.retryDelay$set) {
                    retryDelay$value = Config.$default$retryDelay();
                }
                Duration timeout$value = this.timeout$value;
                if (!this.timeout$set) {
                    timeout$value = Config.$default$timeout();
                }
                Executor scheduler$value = this.scheduler$value;
                if (!this.scheduler$set) {
                    scheduler$value = Config.$default$scheduler();
                }
                return new Config(maxRetries$value, retryDelay$value, timeout$value, scheduler$value);
            }

            public String toString() {
                return "RequestExecutor.Config.ConfigBuilder(maxRetries$value=" + this.maxRetries$value + ", retryDelay$value=" + String.valueOf(this.retryDelay$value) + ", timeout$value=" + String.valueOf(this.timeout$value) + ", scheduler$value=" + String.valueOf(this.scheduler$value) + ")";
            }
        }
    }
}

