/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.connection;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.connection.ConnectionListener;
import xyz.tcheeric.nsecbunker.connection.ConnectionState;

public class CompositeConnectionListener
implements ConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(CompositeConnectionListener.class);
    private final List<ConnectionListener> listeners;

    public CompositeConnectionListener(ConnectionListener ... listeners) {
        this.listeners = new CopyOnWriteArrayList<ConnectionListener>(Arrays.asList(listeners));
    }

    public void addListener(ConnectionListener listener) {
        if (listener != null && listener != this) {
            this.listeners.add(listener);
        }
    }

    public boolean removeListener(ConnectionListener listener) {
        return this.listeners.remove(listener);
    }

    public int size() {
        return this.listeners.size();
    }

    @Override
    public void onConnected(String url) {
        for (ConnectionListener listener : this.listeners) {
            try {
                listener.onConnected(url);
            }
            catch (Exception e) {
                log.warn("Error in ConnectionListener.onConnected: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void onDisconnected(String url, int code, String reason) {
        for (ConnectionListener listener : this.listeners) {
            try {
                listener.onDisconnected(url, code, reason);
            }
            catch (Exception e) {
                log.warn("Error in ConnectionListener.onDisconnected: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void onError(String url, Throwable error) {
        for (ConnectionListener listener : this.listeners) {
            try {
                listener.onError(url, error);
            }
            catch (Exception e) {
                log.warn("Error in ConnectionListener.onError: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void onStateChanged(String url, ConnectionState oldState, ConnectionState newState) {
        for (ConnectionListener listener : this.listeners) {
            try {
                listener.onStateChanged(url, oldState, newState);
            }
            catch (Exception e) {
                log.warn("Error in ConnectionListener.onStateChanged: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void onReconnecting(String url, int attempt) {
        for (ConnectionListener listener : this.listeners) {
            try {
                listener.onReconnecting(url, attempt);
            }
            catch (Exception e) {
                log.warn("Error in ConnectionListener.onReconnecting: {}", (Object)e.getMessage());
            }
        }
    }
}

