/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.connection;

import xyz.tcheeric.nsecbunker.connection.CompositeConnectionListener;
import xyz.tcheeric.nsecbunker.connection.ConnectionState;
import xyz.tcheeric.nsecbunker.connection.LoggingConnectionListener;

public interface ConnectionListener {
    default public void onConnected(String url) {
    }

    default public void onDisconnected(String url, int code, String reason) {
    }

    default public void onError(String url, Throwable error) {
    }

    default public void onStateChanged(String url, ConnectionState oldState, ConnectionState newState) {
    }

    default public void onReconnecting(String url, int attempt) {
    }

    public static ConnectionListener logging(String loggerName) {
        return new LoggingConnectionListener(loggerName);
    }

    public static ConnectionListener logging() {
        return ConnectionListener.logging(ConnectionListener.class.getName());
    }

    public static ConnectionListener composite(ConnectionListener ... listeners) {
        return new CompositeConnectionListener(listeners);
    }
}

