/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.exception;

import xyz.tcheeric.nsecbunker.core.exception.BunkerException;

public class BunkerAuthenticationException
extends BunkerException {
    private static final long serialVersionUID = 1L;
    private final Reason reason;

    public BunkerAuthenticationException(String message) {
        super(message);
        this.reason = Reason.UNKNOWN;
    }

    public BunkerAuthenticationException(String message, Reason reason) {
        super(message);
        this.reason = reason;
    }

    public BunkerAuthenticationException(String message, Throwable cause) {
        super(message, cause);
        this.reason = Reason.UNKNOWN;
    }

    public BunkerAuthenticationException(String message, Reason reason, Throwable cause) {
        super(message, cause);
        this.reason = reason;
    }

    public Reason getReason() {
        return this.reason;
    }

    public static BunkerAuthenticationException tokenExpired() {
        return new BunkerAuthenticationException("Access token has expired", Reason.TOKEN_EXPIRED);
    }

    public static BunkerAuthenticationException tokenRevoked() {
        return new BunkerAuthenticationException("Access token has been revoked", Reason.TOKEN_REVOKED);
    }

    public static BunkerAuthenticationException invalidSecret() {
        return new BunkerAuthenticationException("Invalid secret provided", Reason.INVALID_SECRET);
    }

    public static enum Reason {
        INVALID_CREDENTIALS,
        TOKEN_EXPIRED,
        TOKEN_REVOKED,
        INVALID_SECRET,
        UNAUTHORIZED_ADMIN,
        HANDSHAKE_FAILED,
        UNKNOWN;

    }
}

