/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.exception;

import xyz.tcheeric.nsecbunker.core.exception.BunkerException;

public class BunkerAuthorizationException
extends BunkerException {
    private static final long serialVersionUID = 1L;
    private final String method;
    private final Integer eventKind;

    public BunkerAuthorizationException(String message) {
        super(message);
        this.method = null;
        this.eventKind = null;
    }

    public BunkerAuthorizationException(String message, String method) {
        super(message);
        this.method = method;
        this.eventKind = null;
    }

    public BunkerAuthorizationException(String message, int eventKind) {
        super(message);
        this.method = null;
        this.eventKind = eventKind;
    }

    public BunkerAuthorizationException(String message, String method, Integer eventKind) {
        super(message);
        this.method = method;
        this.eventKind = eventKind;
    }

    public String getMethod() {
        return this.method;
    }

    public Integer getEventKind() {
        return this.eventKind;
    }

    public static BunkerAuthorizationException methodDenied(String method) {
        return new BunkerAuthorizationException("Permission denied for method: " + method, method);
    }

    public static BunkerAuthorizationException eventKindDenied(int eventKind) {
        return new BunkerAuthorizationException("Permission denied for event kind: " + eventKind, eventKind);
    }

    public static BunkerAuthorizationException policyViolation(String policyName) {
        return new BunkerAuthorizationException("Operation violates policy: " + policyName);
    }
}

