/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.exception;

import xyz.tcheeric.nsecbunker.core.exception.BunkerException;

public class BunkerKeyException
extends BunkerException {
    private static final long serialVersionUID = 1L;
    private final String keyName;
    private final Reason reason;

    public BunkerKeyException(String message) {
        super(message);
        this.keyName = null;
        this.reason = Reason.UNKNOWN;
    }

    public BunkerKeyException(String message, String keyName, Reason reason) {
        super(message);
        this.keyName = keyName;
        this.reason = reason;
    }

    public BunkerKeyException(String message, Throwable cause) {
        super(message, cause);
        this.keyName = null;
        this.reason = Reason.UNKNOWN;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Reason getReason() {
        return this.reason;
    }

    public static BunkerKeyException notFound(String keyName) {
        return new BunkerKeyException("Key not found: " + keyName, keyName, Reason.NOT_FOUND);
    }

    public static BunkerKeyException locked(String keyName) {
        return new BunkerKeyException("Key is locked and requires passphrase: " + keyName, keyName, Reason.LOCKED);
    }

    public static BunkerKeyException alreadyExists(String keyName) {
        return new BunkerKeyException("Key already exists: " + keyName, keyName, Reason.ALREADY_EXISTS);
    }

    public static BunkerKeyException invalidPassphrase(String keyName) {
        return new BunkerKeyException("Invalid passphrase for key: " + keyName, keyName, Reason.INVALID_PASSPHRASE);
    }

    public static enum Reason {
        NOT_FOUND,
        LOCKED,
        ALREADY_EXISTS,
        INVALID_PASSPHRASE,
        INVALID_FORMAT,
        CANNOT_DELETE,
        UNKNOWN;

    }
}

