/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.exception;

import xyz.tcheeric.nsecbunker.core.exception.BunkerException;

public class BunkerProtocolException
extends BunkerException {
    private static final long serialVersionUID = 1L;
    private final String requestId;
    private final String errorCode;

    public BunkerProtocolException(String message) {
        super(message);
        this.requestId = null;
        this.errorCode = null;
    }

    public BunkerProtocolException(String message, String requestId) {
        super(message);
        this.requestId = requestId;
        this.errorCode = null;
    }

    public BunkerProtocolException(String message, String requestId, String errorCode) {
        super(message);
        this.requestId = requestId;
        this.errorCode = errorCode;
    }

    public BunkerProtocolException(String message, Throwable cause) {
        super(message, cause);
        this.requestId = null;
        this.errorCode = null;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public static BunkerProtocolException malformedResponse(String details) {
        return new BunkerProtocolException("Malformed protocol response: " + details);
    }

    public static BunkerProtocolException unsupportedMethod(String method) {
        return new BunkerProtocolException("Unsupported NIP-46 method: " + method);
    }

    public static BunkerProtocolException decryptionFailed(Throwable cause) {
        return new BunkerProtocolException("Failed to decrypt NIP-46 message", cause);
    }

    public static BunkerProtocolException encryptionFailed(Throwable cause) {
        return new BunkerProtocolException("Failed to encrypt NIP-46 message", cause);
    }
}

