/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.exception;

import java.time.Duration;
import xyz.tcheeric.nsecbunker.core.exception.BunkerException;

public class BunkerTimeoutException
extends BunkerException {
    private static final long serialVersionUID = 1L;
    private final Duration timeout;
    private final String operation;

    public BunkerTimeoutException(String message) {
        super(message);
        this.timeout = null;
        this.operation = null;
    }

    public BunkerTimeoutException(String message, Duration timeout2, String operation) {
        super(message);
        this.timeout = timeout2;
        this.operation = operation;
    }

    public BunkerTimeoutException(String message, Throwable cause) {
        super(message, cause);
        this.timeout = null;
        this.operation = null;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String getOperation() {
        return this.operation;
    }

    public static BunkerTimeoutException signingTimeout(Duration timeout2) {
        return new BunkerTimeoutException("Signing request timed out after " + timeout2.toMillis() + "ms", timeout2, "sign_event");
    }

    public static BunkerTimeoutException connectionTimeout(Duration timeout2) {
        return new BunkerTimeoutException("Connection timed out after " + timeout2.toMillis() + "ms", timeout2, "connect");
    }

    public static BunkerTimeoutException requestTimeout(String method, Duration timeout2) {
        return new BunkerTimeoutException("Request '" + method + "' timed out after " + timeout2.toMillis() + "ms", timeout2, method);
    }
}

