/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class BunkerConnection {
    public static final String BUNKER_SCHEME = "bunker";
    private final String remotePubkey;
    private final List<String> relays;
    private final String secret;
    private final String token;

    public static BunkerConnectionBuilder forPubkey(String remotePubkey) {
        Objects.requireNonNull(remotePubkey, "remotePubkey must not be null");
        return BunkerConnection.builder().remotePubkey(remotePubkey);
    }

    public List<String> getRelays() {
        return this.relays == null ? Collections.emptyList() : Collections.unmodifiableList(this.relays);
    }

    public boolean hasSecret() {
        return this.secret != null && !this.secret.isEmpty();
    }

    public boolean hasToken() {
        return this.token != null && !this.token.isEmpty();
    }

    public boolean hasCredentials() {
        return this.hasSecret() || this.hasToken();
    }

    public String toConnectionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BUNKER_SCHEME).append("://").append(this.remotePubkey);
        boolean hasParams = false;
        if (this.relays != null && !this.relays.isEmpty()) {
            for (String relay : this.relays) {
                sb.append(hasParams ? "&" : "?");
                sb.append("relay=").append(relay);
                hasParams = true;
            }
        }
        if (this.hasSecret()) {
            sb.append(hasParams ? "&" : "?");
            sb.append("secret=").append(this.secret);
        }
        return sb.toString();
    }

    private static List<String> $default$relays() {
        return Collections.emptyList();
    }

    BunkerConnection(String remotePubkey, List<String> relays, String secret, String token) {
        this.remotePubkey = remotePubkey;
        this.relays = relays;
        this.secret = secret;
        this.token = token;
    }

    public static BunkerConnectionBuilder builder() {
        return new BunkerConnectionBuilder();
    }

    public BunkerConnectionBuilder toBuilder() {
        return new BunkerConnectionBuilder().remotePubkey(this.remotePubkey).relays(this.relays).secret(this.secret).token(this.token);
    }

    public String getRemotePubkey() {
        return this.remotePubkey;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BunkerConnection)) {
            return false;
        }
        BunkerConnection other = (BunkerConnection)o;
        String this$remotePubkey = this.getRemotePubkey();
        String other$remotePubkey = other.getRemotePubkey();
        if (this$remotePubkey == null ? other$remotePubkey != null : !this$remotePubkey.equals(other$remotePubkey)) {
            return false;
        }
        List<String> this$relays = this.getRelays();
        List<String> other$relays = other.getRelays();
        if (this$relays == null ? other$relays != null : !((Object)this$relays).equals(other$relays)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $remotePubkey = this.getRemotePubkey();
        result = result * 59 + ($remotePubkey == null ? 43 : $remotePubkey.hashCode());
        List<String> $relays = this.getRelays();
        result = result * 59 + ($relays == null ? 43 : ((Object)$relays).hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "BunkerConnection(remotePubkey=" + this.getRemotePubkey() + ", relays=" + String.valueOf(this.getRelays()) + ", token=" + this.getToken() + ")";
    }

    public static class BunkerConnectionBuilder {
        private String remotePubkey;
        private boolean relays$set;
        private List<String> relays$value;
        private String secret;
        private String token;

        BunkerConnectionBuilder() {
        }

        public BunkerConnectionBuilder remotePubkey(String remotePubkey) {
            this.remotePubkey = remotePubkey;
            return this;
        }

        public BunkerConnectionBuilder relays(List<String> relays) {
            this.relays$value = relays;
            this.relays$set = true;
            return this;
        }

        public BunkerConnectionBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public BunkerConnectionBuilder token(String token) {
            this.token = token;
            return this;
        }

        public BunkerConnection build() {
            List<String> relays$value = this.relays$value;
            if (!this.relays$set) {
                relays$value = BunkerConnection.$default$relays();
            }
            return new BunkerConnection(this.remotePubkey, relays$value, this.secret, this.token);
        }

        public String toString() {
            return "BunkerConnection.BunkerConnectionBuilder(remotePubkey=" + this.remotePubkey + ", relays$value=" + String.valueOf(this.relays$value) + ", secret=" + this.secret + ", token=" + this.token + ")";
        }
    }
}

