/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import xyz.tcheeric.nsecbunker.core.model.PolicyRule;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=BunkerPolicyBuilder.class)
public final class BunkerPolicy {
    private final String id;
    private final String name;
    private final String description;
    private final List<PolicyRule> rules;
    @JsonProperty(value="created_at")
    private final Instant createdAt;
    @JsonProperty(value="expires_at")
    private final Instant expiresAt;
    private final boolean active;

    public static BunkerPolicyBuilder withName(String name) {
        return BunkerPolicy.builder().name(name);
    }

    public List<PolicyRule> getRules() {
        return this.rules == null ? Collections.emptyList() : Collections.unmodifiableList(this.rules);
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public boolean isExpired() {
        return this.expiresAt != null && Instant.now().isAfter(this.expiresAt);
    }

    public boolean isValid() {
        return this.active && !this.isExpired();
    }

    public Duration getTimeUntilExpiration() {
        if (this.expiresAt == null) {
            return null;
        }
        return Duration.between(Instant.now(), this.expiresAt);
    }

    public boolean isMethodAllowed(String method) {
        if (!this.isValid() || this.rules == null) {
            return false;
        }
        boolean hasExplicitAllow = false;
        for (PolicyRule rule : this.rules) {
            if (!rule.appliesTo(method)) continue;
            if (rule.isDeny()) {
                return false;
            }
            if (!rule.isAllow() || rule.isUsageLimitReached()) continue;
            hasExplicitAllow = true;
        }
        return hasExplicitAllow;
    }

    public boolean isEventKindAllowed(int eventKind) {
        if (!this.isValid() || this.rules == null) {
            return false;
        }
        boolean hasExplicitAllow = false;
        for (PolicyRule rule : this.rules) {
            if (!rule.appliesTo(eventKind)) continue;
            if (rule.isDeny()) {
                return false;
            }
            if (!rule.isAllow() || rule.isUsageLimitReached()) continue;
            hasExplicitAllow = true;
        }
        return hasExplicitAllow;
    }

    public int getRuleCount() {
        return this.rules == null ? 0 : this.rules.size();
    }

    private static boolean $default$active() {
        return true;
    }

    BunkerPolicy(String id, String name, String description, List<PolicyRule> rules, Instant createdAt, Instant expiresAt, boolean active) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.rules = rules;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.active = active;
    }

    public static BunkerPolicyBuilder builder() {
        return new BunkerPolicyBuilder();
    }

    public BunkerPolicyBuilder toBuilder() {
        BunkerPolicyBuilder builder = new BunkerPolicyBuilder().id(this.id).name(this.name).description(this.description).createdAt(this.createdAt).expiresAt(this.expiresAt).active(this.active);
        if (this.rules != null) {
            builder.rules(this.rules);
        }
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BunkerPolicy)) {
            return false;
        }
        BunkerPolicy other = (BunkerPolicy)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<PolicyRule> this$rules = this.getRules();
        List<PolicyRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$expiresAt = this.getExpiresAt();
        Instant other$expiresAt = other.getExpiresAt();
        return !(this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<PolicyRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        return result;
    }

    public String toString() {
        return "BunkerPolicy(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", rules=" + String.valueOf(this.getRules()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", expiresAt=" + String.valueOf(this.getExpiresAt()) + ", active=" + this.isActive() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BunkerPolicyBuilder {
        private String id;
        private String name;
        private String description;
        private ArrayList<PolicyRule> rules;
        private Instant createdAt;
        private Instant expiresAt;
        private boolean active$set;
        private boolean active$value;

        BunkerPolicyBuilder() {
        }

        public BunkerPolicyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BunkerPolicyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BunkerPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BunkerPolicyBuilder rule(PolicyRule rule) {
            if (this.rules == null) {
                this.rules = new ArrayList();
            }
            this.rules.add(rule);
            return this;
        }

        public BunkerPolicyBuilder rules(Collection<? extends PolicyRule> rules) {
            if (rules == null) {
                throw new NullPointerException("rules cannot be null");
            }
            if (this.rules == null) {
                this.rules = new ArrayList();
            }
            this.rules.addAll(rules);
            return this;
        }

        public BunkerPolicyBuilder clearRules() {
            if (this.rules != null) {
                this.rules.clear();
            }
            return this;
        }

        @JsonProperty(value="created_at")
        public BunkerPolicyBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="expires_at")
        public BunkerPolicyBuilder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public BunkerPolicyBuilder active(boolean active) {
            this.active$value = active;
            this.active$set = true;
            return this;
        }

        public BunkerPolicy build() {
            List<PolicyRule> rules = switch (this.rules == null ? 0 : this.rules.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.rules.get(0));
                default -> Collections.unmodifiableList(new ArrayList<PolicyRule>(this.rules));
            };
            boolean active$value = this.active$value;
            if (!this.active$set) {
                active$value = BunkerPolicy.$default$active();
            }
            return new BunkerPolicy(this.id, this.name, this.description, rules, this.createdAt, this.expiresAt, active$value);
        }

        public String toString() {
            return "BunkerPolicy.BunkerPolicyBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", rules=" + String.valueOf(this.rules) + ", createdAt=" + String.valueOf(this.createdAt) + ", expiresAt=" + String.valueOf(this.expiresAt) + ", active$value=" + this.active$value + ")";
        }
    }
}

