/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import xyz.tcheeric.nsecbunker.core.model.BunkerPolicy;
import xyz.tcheeric.nsecbunker.core.model.SigningCondition;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=KeyUserBuilder.class)
public final class KeyUser {
    private final String id;
    @JsonProperty(value="pubkey")
    @JsonAlias(value={"user_pubkey", "userPubkey"})
    private final String pubkeyHex;
    private final String npub;
    @JsonProperty(value="key_name")
    private final String keyName;
    private final String description;
    private final BunkerPolicy policy;
    @JsonProperty(value="policy_id")
    private final String policyId;
    @JsonProperty(value="signing_conditions")
    private final List<SigningCondition> signingConditions;
    @JsonProperty(value="created_at")
    private final Instant createdAt;
    @JsonProperty(value="updated_at")
    private final Instant updatedAt;
    @JsonProperty(value="last_used_at")
    private final Instant lastUsedAt;
    @JsonProperty(value="signing_count")
    private final long signingCount;
    @JsonAlias(value={"is_active", "enabled"})
    private final boolean active;

    public static KeyUserBuilder forPubkey(String pubkeyHex) {
        return KeyUser.builder().pubkeyHex(pubkeyHex);
    }

    public String getPublicKey() {
        return this.pubkeyHex != null ? this.pubkeyHex : this.npub;
    }

    public List<SigningCondition> getSigningConditions() {
        return this.signingConditions == null ? Collections.emptyList() : Collections.unmodifiableList(this.signingConditions);
    }

    public boolean hasPolicy() {
        return this.policy != null || this.policyId != null && !this.policyId.isEmpty();
    }

    public boolean hasSigningConditions() {
        return this.signingConditions != null && !this.signingConditions.isEmpty();
    }

    public boolean hasBeenUsed() {
        return this.signingCount > 0L || this.lastUsedAt != null;
    }

    public boolean isAccessValid() {
        if (!this.active) {
            return false;
        }
        return this.policy == null || this.policy.isValid();
    }

    private static long $default$signingCount() {
        return 0L;
    }

    private static boolean $default$active() {
        return true;
    }

    KeyUser(String id, String pubkeyHex, String npub, String keyName, String description, BunkerPolicy policy, String policyId, List<SigningCondition> signingConditions, Instant createdAt, Instant updatedAt, Instant lastUsedAt, long signingCount, boolean active) {
        this.id = id;
        this.pubkeyHex = pubkeyHex;
        this.npub = npub;
        this.keyName = keyName;
        this.description = description;
        this.policy = policy;
        this.policyId = policyId;
        this.signingConditions = signingConditions;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.lastUsedAt = lastUsedAt;
        this.signingCount = signingCount;
        this.active = active;
    }

    public static KeyUserBuilder builder() {
        return new KeyUserBuilder();
    }

    public KeyUserBuilder toBuilder() {
        KeyUserBuilder builder = new KeyUserBuilder().id(this.id).pubkeyHex(this.pubkeyHex).npub(this.npub).keyName(this.keyName).description(this.description).policy(this.policy).policyId(this.policyId).createdAt(this.createdAt).updatedAt(this.updatedAt).lastUsedAt(this.lastUsedAt).signingCount(this.signingCount).active(this.active);
        if (this.signingConditions != null) {
            builder.signingConditions(this.signingConditions);
        }
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public String getPubkeyHex() {
        return this.pubkeyHex;
    }

    public String getNpub() {
        return this.npub;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getDescription() {
        return this.description;
    }

    public BunkerPolicy getPolicy() {
        return this.policy;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public Instant getLastUsedAt() {
        return this.lastUsedAt;
    }

    public long getSigningCount() {
        return this.signingCount;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyUser)) {
            return false;
        }
        KeyUser other = (KeyUser)o;
        if (this.getSigningCount() != other.getSigningCount()) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$pubkeyHex = this.getPubkeyHex();
        String other$pubkeyHex = other.getPubkeyHex();
        if (this$pubkeyHex == null ? other$pubkeyHex != null : !this$pubkeyHex.equals(other$pubkeyHex)) {
            return false;
        }
        String this$npub = this.getNpub();
        String other$npub = other.getNpub();
        if (this$npub == null ? other$npub != null : !this$npub.equals(other$npub)) {
            return false;
        }
        String this$keyName = this.getKeyName();
        String other$keyName = other.getKeyName();
        if (this$keyName == null ? other$keyName != null : !this$keyName.equals(other$keyName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        BunkerPolicy this$policy = this.getPolicy();
        BunkerPolicy other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy)) {
            return false;
        }
        String this$policyId = this.getPolicyId();
        String other$policyId = other.getPolicyId();
        if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
            return false;
        }
        List<SigningCondition> this$signingConditions = this.getSigningConditions();
        List<SigningCondition> other$signingConditions = other.getSigningConditions();
        if (this$signingConditions == null ? other$signingConditions != null : !((Object)this$signingConditions).equals(other$signingConditions)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Instant this$lastUsedAt = this.getLastUsedAt();
        Instant other$lastUsedAt = other.getLastUsedAt();
        return !(this$lastUsedAt == null ? other$lastUsedAt != null : !((Object)this$lastUsedAt).equals(other$lastUsedAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $signingCount = this.getSigningCount();
        result = result * 59 + (int)($signingCount >>> 32 ^ $signingCount);
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $pubkeyHex = this.getPubkeyHex();
        result = result * 59 + ($pubkeyHex == null ? 43 : $pubkeyHex.hashCode());
        String $npub = this.getNpub();
        result = result * 59 + ($npub == null ? 43 : $npub.hashCode());
        String $keyName = this.getKeyName();
        result = result * 59 + ($keyName == null ? 43 : $keyName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        BunkerPolicy $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        String $policyId = this.getPolicyId();
        result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
        List<SigningCondition> $signingConditions = this.getSigningConditions();
        result = result * 59 + ($signingConditions == null ? 43 : ((Object)$signingConditions).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Instant $lastUsedAt = this.getLastUsedAt();
        result = result * 59 + ($lastUsedAt == null ? 43 : ((Object)$lastUsedAt).hashCode());
        return result;
    }

    public String toString() {
        return "KeyUser(id=" + this.getId() + ", pubkeyHex=" + this.getPubkeyHex() + ", npub=" + this.getNpub() + ", keyName=" + this.getKeyName() + ", description=" + this.getDescription() + ", policy=" + String.valueOf(this.getPolicy()) + ", policyId=" + this.getPolicyId() + ", signingConditions=" + String.valueOf(this.getSigningConditions()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", lastUsedAt=" + String.valueOf(this.getLastUsedAt()) + ", signingCount=" + this.getSigningCount() + ", active=" + this.isActive() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class KeyUserBuilder {
        private String id;
        private String pubkeyHex;
        private String npub;
        private String keyName;
        private String description;
        private BunkerPolicy policy;
        private String policyId;
        private ArrayList<SigningCondition> signingConditions;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant lastUsedAt;
        private boolean signingCount$set;
        private long signingCount$value;
        private boolean active$set;
        private boolean active$value;

        KeyUserBuilder() {
        }

        public KeyUserBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="pubkey")
        @JsonAlias(value={"user_pubkey", "userPubkey"})
        public KeyUserBuilder pubkeyHex(String pubkeyHex) {
            this.pubkeyHex = pubkeyHex;
            return this;
        }

        public KeyUserBuilder npub(String npub) {
            this.npub = npub;
            return this;
        }

        @JsonProperty(value="key_name")
        public KeyUserBuilder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public KeyUserBuilder description(String description) {
            this.description = description;
            return this;
        }

        public KeyUserBuilder policy(BunkerPolicy policy) {
            this.policy = policy;
            return this;
        }

        @JsonProperty(value="policy_id")
        public KeyUserBuilder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public KeyUserBuilder signingCondition(SigningCondition signingCondition) {
            if (this.signingConditions == null) {
                this.signingConditions = new ArrayList();
            }
            this.signingConditions.add(signingCondition);
            return this;
        }

        @JsonProperty(value="signing_conditions")
        public KeyUserBuilder signingConditions(Collection<? extends SigningCondition> signingConditions) {
            if (signingConditions == null) {
                throw new NullPointerException("signingConditions cannot be null");
            }
            if (this.signingConditions == null) {
                this.signingConditions = new ArrayList();
            }
            this.signingConditions.addAll(signingConditions);
            return this;
        }

        public KeyUserBuilder clearSigningConditions() {
            if (this.signingConditions != null) {
                this.signingConditions.clear();
            }
            return this;
        }

        @JsonProperty(value="created_at")
        public KeyUserBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="updated_at")
        public KeyUserBuilder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="last_used_at")
        public KeyUserBuilder lastUsedAt(Instant lastUsedAt) {
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        @JsonProperty(value="signing_count")
        public KeyUserBuilder signingCount(long signingCount) {
            this.signingCount$value = signingCount;
            this.signingCount$set = true;
            return this;
        }

        @JsonAlias(value={"is_active", "enabled"})
        public KeyUserBuilder active(boolean active) {
            this.active$value = active;
            this.active$set = true;
            return this;
        }

        public KeyUser build() {
            List<SigningCondition> signingConditions = switch (this.signingConditions == null ? 0 : this.signingConditions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.signingConditions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<SigningCondition>(this.signingConditions));
            };
            long signingCount$value = this.signingCount$value;
            if (!this.signingCount$set) {
                signingCount$value = KeyUser.$default$signingCount();
            }
            boolean active$value = this.active$value;
            if (!this.active$set) {
                active$value = KeyUser.$default$active();
            }
            return new KeyUser(this.id, this.pubkeyHex, this.npub, this.keyName, this.description, this.policy, this.policyId, signingConditions, this.createdAt, this.updatedAt, this.lastUsedAt, signingCount$value, active$value);
        }

        public String toString() {
            return "KeyUser.KeyUserBuilder(id=" + this.id + ", pubkeyHex=" + this.pubkeyHex + ", npub=" + this.npub + ", keyName=" + this.keyName + ", description=" + this.description + ", policy=" + String.valueOf(this.policy) + ", policyId=" + this.policyId + ", signingConditions=" + String.valueOf(this.signingConditions) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", lastUsedAt=" + String.valueOf(this.lastUsedAt) + ", signingCount$value=" + this.signingCount$value + ", active$value=" + this.active$value + ")";
        }
    }
}

