/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.core.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=PolicyRuleBuilder.class)
public final class PolicyRule {
    private final RuleType type;
    private final String method;
    @JsonProperty(value="kind")
    private final Integer eventKind;
    @JsonProperty(value="use_count")
    private final Long maxUsage;
    @JsonProperty(value="current_usage_count")
    private final long currentUsage;
    private final String description;

    public static PolicyRule allowMethod(String method) {
        return PolicyRule.builder().type(RuleType.ALLOW).method(method).build();
    }

    public static PolicyRule allowEventKind(int eventKind) {
        return PolicyRule.builder().type(RuleType.ALLOW).eventKind(eventKind).build();
    }

    public static PolicyRule denyMethod(String method) {
        return PolicyRule.builder().type(RuleType.DENY).method(method).build();
    }

    public static PolicyRule denyEventKind(int eventKind) {
        return PolicyRule.builder().type(RuleType.DENY).eventKind(eventKind).build();
    }

    public boolean hasUsageLimit() {
        return this.maxUsage != null && this.maxUsage > 0L;
    }

    public boolean isUsageLimitReached() {
        return this.hasUsageLimit() && this.currentUsage >= this.maxUsage;
    }

    public long getRemainingUsage() {
        if (!this.hasUsageLimit()) {
            return -1L;
        }
        return Math.max(0L, this.maxUsage - this.currentUsage);
    }

    public boolean appliesTo(String targetMethod) {
        return this.method == null || this.method.equals(targetMethod);
    }

    public boolean appliesTo(int targetKind) {
        return this.eventKind == null || this.eventKind == targetKind;
    }

    public boolean isAllow() {
        return this.type == RuleType.ALLOW;
    }

    public boolean isDeny() {
        return this.type == RuleType.DENY;
    }

    private static RuleType $default$type() {
        return RuleType.ALLOW;
    }

    private static long $default$currentUsage() {
        return 0L;
    }

    PolicyRule(RuleType type, String method, Integer eventKind, Long maxUsage, long currentUsage, String description) {
        this.type = type;
        this.method = method;
        this.eventKind = eventKind;
        this.maxUsage = maxUsage;
        this.currentUsage = currentUsage;
        this.description = description;
    }

    public static PolicyRuleBuilder builder() {
        return new PolicyRuleBuilder();
    }

    public PolicyRuleBuilder toBuilder() {
        return new PolicyRuleBuilder().type(this.type).method(this.method).eventKind(this.eventKind).maxUsage(this.maxUsage).currentUsage(this.currentUsage).description(this.description);
    }

    public RuleType getType() {
        return this.type;
    }

    public String getMethod() {
        return this.method;
    }

    public Integer getEventKind() {
        return this.eventKind;
    }

    public Long getMaxUsage() {
        return this.maxUsage;
    }

    public long getCurrentUsage() {
        return this.currentUsage;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicyRule)) {
            return false;
        }
        PolicyRule other = (PolicyRule)o;
        if (this.getCurrentUsage() != other.getCurrentUsage()) {
            return false;
        }
        Integer this$eventKind = this.getEventKind();
        Integer other$eventKind = other.getEventKind();
        if (this$eventKind == null ? other$eventKind != null : !((Object)this$eventKind).equals(other$eventKind)) {
            return false;
        }
        Long this$maxUsage = this.getMaxUsage();
        Long other$maxUsage = other.getMaxUsage();
        if (this$maxUsage == null ? other$maxUsage != null : !((Object)this$maxUsage).equals(other$maxUsage)) {
            return false;
        }
        RuleType this$type = this.getType();
        RuleType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $currentUsage = this.getCurrentUsage();
        result = result * 59 + (int)($currentUsage >>> 32 ^ $currentUsage);
        Integer $eventKind = this.getEventKind();
        result = result * 59 + ($eventKind == null ? 43 : ((Object)$eventKind).hashCode());
        Long $maxUsage = this.getMaxUsage();
        result = result * 59 + ($maxUsage == null ? 43 : ((Object)$maxUsage).hashCode());
        RuleType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "PolicyRule(type=" + String.valueOf((Object)this.getType()) + ", method=" + this.getMethod() + ", eventKind=" + this.getEventKind() + ", maxUsage=" + this.getMaxUsage() + ", currentUsage=" + this.getCurrentUsage() + ", description=" + this.getDescription() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class PolicyRuleBuilder {
        private boolean type$set;
        private RuleType type$value;
        private String method;
        private Integer eventKind;
        private Long maxUsage;
        private boolean currentUsage$set;
        private long currentUsage$value;
        private String description;

        PolicyRuleBuilder() {
        }

        public PolicyRuleBuilder type(RuleType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public PolicyRuleBuilder method(String method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="kind")
        public PolicyRuleBuilder eventKind(Integer eventKind) {
            this.eventKind = eventKind;
            return this;
        }

        @JsonProperty(value="use_count")
        public PolicyRuleBuilder maxUsage(Long maxUsage) {
            this.maxUsage = maxUsage;
            return this;
        }

        @JsonProperty(value="current_usage_count")
        public PolicyRuleBuilder currentUsage(long currentUsage) {
            this.currentUsage$value = currentUsage;
            this.currentUsage$set = true;
            return this;
        }

        public PolicyRuleBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PolicyRule build() {
            RuleType type$value = this.type$value;
            if (!this.type$set) {
                type$value = PolicyRule.$default$type();
            }
            long currentUsage$value = this.currentUsage$value;
            if (!this.currentUsage$set) {
                currentUsage$value = PolicyRule.$default$currentUsage();
            }
            return new PolicyRule(type$value, this.method, this.eventKind, this.maxUsage, currentUsage$value, this.description);
        }

        public String toString() {
            return "PolicyRule.PolicyRuleBuilder(type$value=" + String.valueOf((Object)this.type$value) + ", method=" + this.method + ", eventKind=" + this.eventKind + ", maxUsage=" + this.maxUsage + ", currentUsage$value=" + this.currentUsage$value + ", description=" + this.description + ")";
        }
    }

    public static enum RuleType {
        ALLOW,
        DENY;

    }
}

