/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.nip46;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Error;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Response;

public class Nip46Decoder {
    private static final Logger log = LoggerFactory.getLogger(Nip46Decoder.class);
    private final ObjectMapper objectMapper;

    public Nip46Decoder() {
        this(new ObjectMapper());
    }

    public Nip46Decoder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
    }

    public Nip46Request decodeRequest(String json) {
        if (json == null || json.isBlank()) {
            throw new IllegalArgumentException("JSON must not be null or blank");
        }
        try {
            log.debug("Decoding request: {}", (Object)json);
            return this.objectMapper.readValue(json, Nip46Request.class);
        }
        catch (JsonProcessingException e) {
            throw new Nip46DecodingException("Failed to decode request: " + e.getMessage(), e);
        }
    }

    public Optional<Nip46Request> tryDecodeRequest(String json) {
        try {
            return Optional.of(this.decodeRequest(json));
        }
        catch (Exception e) {
            log.debug("Failed to decode request: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public Nip46Response decodeResponse(String json) {
        if (json == null || json.isBlank()) {
            throw new IllegalArgumentException("JSON must not be null or blank");
        }
        try {
            String result;
            log.debug("Decoding response: {}", (Object)json);
            JsonNode node = this.objectMapper.readTree(json);
            String id = node.has("id") && !node.get("id").isNull() ? node.get("id").asText() : null;
            String string = result = node.has("result") && !node.get("result").isNull() ? node.get("result").asText() : null;
            if (node.has("error") && !node.get("error").isNull()) {
                Nip46Error error;
                JsonNode errorNode = node.get("error");
                if (errorNode.isTextual()) {
                    error = Nip46Error.of("ERROR", errorNode.asText());
                } else if (errorNode.isObject()) {
                    String code = errorNode.has("code") ? errorNode.get("code").asText() : "ERROR";
                    String message = errorNode.has("message") ? errorNode.get("message").asText() : "Unknown error";
                    error = Nip46Error.of(code, message);
                } else {
                    error = Nip46Error.of("ERROR", errorNode.toString());
                }
                return Nip46Response.error(id, error);
            }
            return Nip46Response.success(id, result);
        }
        catch (JsonProcessingException e) {
            throw new Nip46DecodingException("Failed to decode response: " + e.getMessage(), e);
        }
    }

    public Optional<Nip46Response> tryDecodeResponse(String json) {
        try {
            return Optional.of(this.decodeResponse(json));
        }
        catch (Exception e) {
            log.debug("Failed to decode response: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public boolean isRequest(String json) {
        if (json == null || json.isBlank()) {
            return false;
        }
        try {
            JsonNode node = this.objectMapper.readTree(json);
            return node.has("method");
        }
        catch (JsonProcessingException e) {
            return false;
        }
    }

    public boolean isResponse(String json) {
        if (json == null || json.isBlank()) {
            return false;
        }
        try {
            JsonNode node = this.objectMapper.readTree(json);
            return node.has("result") || node.has("error");
        }
        catch (JsonProcessingException e) {
            return false;
        }
    }

    public Optional<String> extractId(String json) {
        if (json == null || json.isBlank()) {
            return Optional.empty();
        }
        try {
            JsonNode node = this.objectMapper.readTree(json);
            JsonNode idNode = node.get("id");
            if (idNode != null && idNode.isTextual()) {
                return Optional.of(idNode.asText());
            }
            return Optional.empty();
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    public Optional<String> extractMethod(String json) {
        if (json == null || json.isBlank()) {
            return Optional.empty();
        }
        try {
            JsonNode node = this.objectMapper.readTree(json);
            JsonNode methodNode = node.get("method");
            if (methodNode != null && methodNode.isTextual()) {
                return Optional.of(methodNode.asText());
            }
            return Optional.empty();
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    public <T> T decode(String json, Class<T> clazz) {
        if (json == null || json.isBlank()) {
            throw new IllegalArgumentException("JSON must not be null or blank");
        }
        try {
            return this.objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new Nip46DecodingException("Failed to decode: " + e.getMessage(), e);
        }
    }

    public static class Nip46DecodingException
    extends RuntimeException {
        public Nip46DecodingException(String message, Throwable cause) {
            super(message, cause);
        }

        public Nip46DecodingException(String message) {
            super(message);
        }
    }
}

