/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.nip46;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Request;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Response;

public class Nip46Encoder {
    private static final Logger log = LoggerFactory.getLogger(Nip46Encoder.class);
    private final ObjectMapper objectMapper;

    public Nip46Encoder() {
        this(new ObjectMapper());
    }

    public Nip46Encoder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
    }

    public String encodeRequest(Nip46Request request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null");
        }
        try {
            String json = this.objectMapper.writeValueAsString(request);
            log.debug("Encoded request: {}", (Object)json);
            return json;
        }
        catch (JsonProcessingException e) {
            throw new Nip46EncodingException("Failed to encode request", e);
        }
    }

    public String encodeResponse(Nip46Response response) {
        if (response == null) {
            throw new IllegalArgumentException("Response must not be null");
        }
        try {
            String json = this.objectMapper.writeValueAsString(response);
            log.debug("Encoded response: {}", (Object)json);
            return json;
        }
        catch (JsonProcessingException e) {
            throw new Nip46EncodingException("Failed to encode response", e);
        }
    }

    public String encode(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Object must not be null");
        }
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new Nip46EncodingException("Failed to encode object", e);
        }
    }

    public static class Nip46EncodingException
    extends RuntimeException {
        public Nip46EncodingException(String message, Throwable cause) {
            super(message, cause);
        }

        public Nip46EncodingException(String message) {
            super(message);
        }
    }
}

