/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.nip46;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Nip46ErrorBuilder.class)
public class Nip46Error {
    @JsonProperty(value="code")
    private final String code;
    @JsonProperty(value="message")
    private final String message;

    public static Nip46Error of(String code, String message) {
        return Nip46Error.builder().code(code).message(message).build();
    }

    public static Nip46Error unauthorized(String message) {
        return Nip46Error.of("UNAUTHORIZED", message);
    }

    public static Nip46Error invalidRequest(String message) {
        return Nip46Error.of("INVALID_REQUEST", message);
    }

    public static Nip46Error timeout(String message) {
        return Nip46Error.of("TIMEOUT", message);
    }

    public static Nip46Error internalError(String message) {
        return Nip46Error.of("INTERNAL_ERROR", message);
    }

    public String toString() {
        return "Nip46Error{code='" + this.code + "', message='" + this.message + "'}";
    }

    Nip46Error(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public static Nip46ErrorBuilder builder() {
        return new Nip46ErrorBuilder();
    }

    public Nip46ErrorBuilder toBuilder() {
        return new Nip46ErrorBuilder().code(this.code).message(this.message);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nip46Error)) {
            return false;
        }
        Nip46Error other = (Nip46Error)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nip46Error;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Nip46ErrorBuilder {
        private String code;
        private String message;

        Nip46ErrorBuilder() {
        }

        @JsonProperty(value="code")
        public Nip46ErrorBuilder code(String code) {
            this.code = code;
            return this;
        }

        @JsonProperty(value="message")
        public Nip46ErrorBuilder message(String message) {
            this.message = message;
            return this;
        }

        public Nip46Error build() {
            return new Nip46Error(this.code, this.message);
        }

        public String toString() {
            return "Nip46Error.Nip46ErrorBuilder(code=" + this.code + ", message=" + this.message + ")";
        }
    }
}

