/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.nip46;

import com.fasterxml.jackson.annotation.JsonValue;

public enum Nip46Method {
    CONNECT("connect"),
    GET_PUBLIC_KEY("get_public_key"),
    SIGN_EVENT("sign_event"),
    NIP04_ENCRYPT("nip04_encrypt"),
    NIP04_DECRYPT("nip04_decrypt"),
    NIP44_ENCRYPT("nip44_encrypt"),
    NIP44_DECRYPT("nip44_decrypt"),
    PING("ping"),
    GET_RELAYS("get_relays");

    private final String value;

    private Nip46Method(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public static Nip46Method fromValue(String value) {
        for (Nip46Method method : Nip46Method.values()) {
            if (!method.value.equals(value)) continue;
            return method;
        }
        throw new IllegalArgumentException("Unknown NIP-46 method: " + value);
    }

    public static Nip46Method tryFromValue(String value) {
        for (Nip46Method method : Nip46Method.values()) {
            if (!method.value.equals(value)) continue;
            return method;
        }
        return null;
    }

    public String toString() {
        return this.value;
    }
}

