/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.nsecbunker.protocol.nip46;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import xyz.tcheeric.nsecbunker.protocol.nip46.Nip46Error;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Nip46ResponseBuilder.class)
public class Nip46Response {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="result")
    private final String result;
    @JsonProperty(value="error")
    private final Nip46Error error;

    @JsonIgnore
    public boolean isSuccess() {
        return this.error == null;
    }

    @JsonIgnore
    public boolean isError() {
        return this.error != null;
    }

    @JsonIgnore
    public String getResultOrThrow() {
        if (this.isError()) {
            throw new IllegalStateException("Response is an error: " + String.valueOf(this.error));
        }
        return this.result;
    }

    @JsonIgnore
    public String getErrorCode() {
        return this.error != null ? this.error.getCode() : null;
    }

    @JsonIgnore
    public String getErrorMessage() {
        return this.error != null ? this.error.getMessage() : null;
    }

    public static Nip46Response success(String id, String result) {
        return Nip46Response.builder().id(id).result(result).build();
    }

    public static Nip46Response error(String id, Nip46Error error) {
        return Nip46Response.builder().id(id).error(error).build();
    }

    public static Nip46Response error(String id, String code, String message) {
        return Nip46Response.error(id, Nip46Error.of(code, message));
    }

    public static Nip46Response ack(String id) {
        return Nip46Response.success(id, "ack");
    }

    public static Nip46Response pong(String id) {
        return Nip46Response.success(id, "pong");
    }

    public String toString() {
        if (this.isSuccess()) {
            return "Nip46Response{id='" + this.id + "', result='" + this.result + "'}";
        }
        return "Nip46Response{id='" + this.id + "', error=" + String.valueOf(this.error) + "}";
    }

    Nip46Response(String id, String result, Nip46Error error) {
        this.id = id;
        this.result = result;
        this.error = error;
    }

    public static Nip46ResponseBuilder builder() {
        return new Nip46ResponseBuilder();
    }

    public Nip46ResponseBuilder toBuilder() {
        return new Nip46ResponseBuilder().id(this.id).result(this.result).error(this.error);
    }

    public String getId() {
        return this.id;
    }

    public String getResult() {
        return this.result;
    }

    public Nip46Error getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nip46Response)) {
            return false;
        }
        Nip46Response other = (Nip46Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Nip46Error this$error = this.getError();
        Nip46Error other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nip46Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Nip46Error $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Nip46ResponseBuilder {
        private String id;
        private String result;
        private Nip46Error error;

        Nip46ResponseBuilder() {
        }

        @JsonProperty(value="id")
        public Nip46ResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="result")
        public Nip46ResponseBuilder result(String result) {
            this.result = result;
            return this;
        }

        @JsonProperty(value="error")
        public Nip46ResponseBuilder error(Nip46Error error) {
            this.error = error;
            return this;
        }

        public Nip46Response build() {
            return new Nip46Response(this.id, this.result, this.error);
        }

        public String toString() {
            return "Nip46Response.Nip46ResponseBuilder(id=" + this.id + ", result=" + this.result + ", error=" + String.valueOf(this.error) + ")";
        }
    }
}

