/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli;

import java.util.Map;
import xyz.tcheeric.wallet.core.util.HexCaseUtils;

public final class CliUtils {
    private CliUtils() {
    }

    public static void ensureH2Backend() {
        CliUtils.ensureH2Backend(System.getenv());
    }

    static void ensureH2Backend(Map<String, String> env) {
        String storage = env.getOrDefault("WALLET_STORAGE", "file");
        if (!"h2".equalsIgnoreCase(storage)) {
            throw new IllegalStateException("H2 backend required: set WALLET_STORAGE=h2 for persistence");
        }
    }

    public static String normalizeKeysetId(String keyset) {
        if (keyset == null) {
            return null;
        }
        String trimmed = keyset.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (HexCaseUtils.hasMixedCaseHexLetters(trimmed)) {
            throw new IllegalArgumentException("Invalid keyset id. Mixed-case not allowed; use lowercase 64-hex. Suggestion: Provide a 64-character lowercase hex string (32 bytes) without 0x prefix.");
        }
        if (!trimmed.matches("[0-9a-fA-F]{64}")) {
            throw new IllegalArgumentException("Invalid keyset id length. Must be exactly 64 hex characters. Suggestion: Provide a 64-character lowercase hex string (32 bytes) without 0x prefix.");
        }
        return trimmed.toLowerCase();
    }
}

