/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.events.CliLoggingSubscriber;
import xyz.tcheeric.wallet.cli.nostr.NostrTransferPublisher;
import xyz.tcheeric.wallet.cli.recovery.WalletRecoveryServiceFactory;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.H2WalletStorageAdapter;
import xyz.tcheeric.wallet.core.MeltService;
import xyz.tcheeric.wallet.core.MintingService;
import xyz.tcheeric.wallet.core.ReceiveService;
import xyz.tcheeric.wallet.core.SendService;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.VoucherBackupServiceImpl;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.VoucherServiceImpl;
import xyz.tcheeric.wallet.core.WalletServices;
import xyz.tcheeric.wallet.core.application.ReceiveUseCase;
import xyz.tcheeric.wallet.core.application.SendUseCase;
import xyz.tcheeric.wallet.core.application.WalletApplicationService;
import xyz.tcheeric.wallet.core.domain.events.DomainEventPublisher;
import xyz.tcheeric.wallet.core.domain.events.DomainEventSubscriber;
import xyz.tcheeric.wallet.core.domain.events.SynchronousDomainEventPublisher;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto44;
import xyz.tcheeric.wallet.core.nostr.dm.DmService;
import xyz.tcheeric.wallet.core.nostr.dm.DmServiceNip04;
import xyz.tcheeric.wallet.core.nostr.dm.DmServiceNip44;
import xyz.tcheeric.wallet.core.nostr.dm.GatewayDmAdapter;
import xyz.tcheeric.wallet.core.nostr.ports.TransferPublisher;
import xyz.tcheeric.wallet.core.ports.WalletStorage;
import xyz.tcheeric.wallet.core.security.EncryptionService;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;
import xyz.tcheeric.wallet.core.token.TokenCodec;
import xyz.tcheeric.wallet.core.token.TokenV4Codec;
import xyz.tcheeric.wallet.infra.nip04.DmCryptoNip04;
import xyz.tcheeric.wallet.infra.nip42.CanonicalNip42AuthProvider;
import xyz.tcheeric.wallet.infra.nip44.DmCryptoNip44;
import xyz.tcheeric.wallet.storage.file.FileWalletStorage;

public class WalletCliConfiguration
implements CommandLine.IFactory {
    private final BalanceService service;
    private final NostrGatewayService nostrGateway;
    private final TokenCodec tokenCodec;
    private final CommandLine.IFactory defaultFactory = CommandLine.defaultFactory();
    private BalanceService sendServiceInstance;
    private BalanceService receiveServiceInstance;
    private WalletApplicationService applicationService;
    private TransferPublisher transferPublisher;
    private DomainEventPublisher domainEventPublisher;
    private final List<DomainEventSubscriber> deferredSubscribers = new CopyOnWriteArrayList<DomainEventSubscriber>();
    private DmService dmService;
    private WalletRecoveryServiceFactory recoveryServiceFactory;
    private VoucherService voucherService;

    public WalletCliConfiguration(BalanceService service, NostrGatewayService nostrGateway) {
        this(service, nostrGateway, new TokenV4Codec());
    }

    public WalletCliConfiguration(BalanceService service, NostrGatewayService nostrGateway, TokenCodec tokenCodec) {
        this.service = Objects.requireNonNull(service, "service");
        this.nostrGateway = Objects.requireNonNull(nostrGateway, "nostrGateway");
        this.tokenCodec = Objects.requireNonNull(tokenCodec, "tokenCodec");
    }

    public static WalletCliConfiguration fromDefaults() {
        BalanceService svc = WalletServices.createDefault();
        CanonicalNip42AuthProvider authProvider = new CanonicalNip42AuthProvider();
        NostrJavaRelayClientFactory factory2 = new NostrJavaRelayClientFactory(authProvider);
        NostrGatewayService gateway = NostrGatewayService.createDefaultWithFactory(factory2);
        return new WalletCliConfiguration(svc, gateway);
    }

    public CommandLine commandLine() {
        CommandLine cmd = new CommandLine(new WalletMain(this.service), this);
        cmd.setExecutionExceptionHandler((ex, commandLine, parseResult) -> {
            commandLine.getErr().println("Error: " + ex.getMessage());
            return 2;
        });
        return cmd;
    }

    @Override
    public <K> K create(Class<K> targetClass) throws Exception {
        try {
            if (this.hasConstructor(targetClass, SendUseCase.class, Boolean.TYPE)) {
                WalletApplicationService app = this.ensureApplicationService();
                return targetClass.getDeclaredConstructor(SendUseCase.class, Boolean.TYPE).newInstance(app, this.requiresH2Backend());
            }
            if (this.hasConstructor(targetClass, ReceiveUseCase.class, Boolean.TYPE)) {
                WalletApplicationService app = this.ensureApplicationService();
                return targetClass.getDeclaredConstructor(ReceiveUseCase.class, Boolean.TYPE).newInstance(app, this.requiresH2Backend());
            }
            if (this.hasConstructor(targetClass, SendUseCase.class)) {
                return targetClass.getDeclaredConstructor(SendUseCase.class).newInstance(this.ensureApplicationService());
            }
            if (this.hasConstructor(targetClass, ReceiveUseCase.class)) {
                return targetClass.getDeclaredConstructor(ReceiveUseCase.class).newInstance(this.ensureApplicationService());
            }
            if (this.hasConstructor(targetClass, DmService.class)) {
                return targetClass.getDeclaredConstructor(DmService.class).newInstance(this.ensureDmService());
            }
            if (this.hasConstructor(targetClass, ReceiveService.class, NostrGatewayService.class, TokenCodec.class)) {
                BalanceService svc = this.ensureReceiveService();
                return targetClass.getDeclaredConstructor(ReceiveService.class, NostrGatewayService.class, TokenCodec.class).newInstance((ReceiveService)svc, this.nostrGateway, this.tokenCodec);
            }
            if (this.hasConstructor(targetClass, SendService.class, NostrGatewayService.class, TokenCodec.class)) {
                BalanceService svc = this.ensureSendService();
                return targetClass.getDeclaredConstructor(SendService.class, NostrGatewayService.class, TokenCodec.class).newInstance((SendService)svc, this.nostrGateway, this.tokenCodec);
            }
            if (this.hasConstructor(targetClass, SendService.class, TokenCodec.class)) {
                BalanceService svc = this.ensureSendService();
                return targetClass.getDeclaredConstructor(SendService.class, TokenCodec.class).newInstance((SendService)svc, this.tokenCodec);
            }
            if (this.hasConstructor(targetClass, ReceiveService.class, NostrGatewayService.class)) {
                BalanceService svc = this.ensureReceiveService();
                return targetClass.getDeclaredConstructor(ReceiveService.class, NostrGatewayService.class).newInstance((ReceiveService)svc, this.nostrGateway);
            }
            if (this.hasConstructor(targetClass, SendService.class, NostrGatewayService.class)) {
                BalanceService svc = this.ensureSendService();
                return targetClass.getDeclaredConstructor(SendService.class, NostrGatewayService.class).newInstance((SendService)svc, this.nostrGateway);
            }
            if (this.hasConstructor(targetClass, SendService.class)) {
                BalanceService svc = this.ensureSendService();
                return targetClass.getDeclaredConstructor(SendService.class).newInstance((SendService)svc);
            }
            if (this.hasConstructor(targetClass, ReceiveService.class)) {
                BalanceService svc = this.ensureReceiveService();
                return targetClass.getDeclaredConstructor(ReceiveService.class).newInstance((ReceiveService)svc);
            }
            if (this.hasConstructor(targetClass, MintingService.class)) {
                BalanceService svc = this.service instanceof MintingService ? this.service : WalletServices.createDefault(Map.of("WALLET_STORAGE", "h2"));
                return targetClass.getDeclaredConstructor(MintingService.class).newInstance((MintingService)svc);
            }
            if (this.hasConstructor(targetClass, MeltService.class)) {
                BalanceService svc = this.service instanceof MeltService ? this.service : WalletServices.createDefault(Map.of("WALLET_STORAGE", "h2"));
                return targetClass.getDeclaredConstructor(MeltService.class).newInstance((MeltService)svc);
            }
            if (this.hasConstructor(targetClass, VoucherService.class)) {
                return targetClass.getDeclaredConstructor(VoucherService.class).newInstance(this.ensureVoucherService());
            }
            if (this.hasConstructor(targetClass, BalanceService.class)) {
                return targetClass.getDeclaredConstructor(BalanceService.class).newInstance(this.service);
            }
            if (this.hasConstructor(targetClass, NostrGatewayService.class)) {
                return targetClass.getDeclaredConstructor(NostrGatewayService.class).newInstance(this.nostrGateway);
            }
            if (this.hasConstructor(targetClass, WalletRecoveryServiceFactory.class, BalanceService.class)) {
                return targetClass.getDeclaredConstructor(WalletRecoveryServiceFactory.class, BalanceService.class).newInstance(this.ensureRecoveryServiceFactory(), this.service);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.defaultFactory.create(targetClass);
    }

    private BalanceService ensureSendService() {
        if (this.sendServiceInstance != null) {
            return this.sendServiceInstance;
        }
        this.sendServiceInstance = this.service instanceof SendService ? this.service : WalletServices.createDefault(Map.of("WALLET_STORAGE", "h2"));
        return this.sendServiceInstance;
    }

    private BalanceService ensureReceiveService() {
        if (this.receiveServiceInstance != null) {
            return this.receiveServiceInstance;
        }
        if (this.service instanceof ReceiveService) {
            this.receiveServiceInstance = this.service;
            return this.receiveServiceInstance;
        }
        BalanceService candidate = this.ensureSendService();
        this.receiveServiceInstance = candidate instanceof ReceiveService ? candidate : WalletServices.createDefault(Map.of("WALLET_STORAGE", "h2"));
        return this.receiveServiceInstance;
    }

    private WalletApplicationService ensureApplicationService() {
        if (this.applicationService == null) {
            BalanceService sendSvc = this.ensureSendService();
            BalanceService receiveSvc = this.ensureReceiveService();
            if (!(sendSvc instanceof SendService) || !(receiveSvc instanceof ReceiveService)) {
                throw new IllegalStateException("Wallet services do not support send/receive operations");
            }
            this.applicationService = new WalletApplicationService((SendService)sendSvc, (ReceiveService)receiveSvc, this.tokenCodec, this.ensureTransferPublisher(), this.ensureDomainEventPublisher());
        }
        return this.applicationService;
    }

    private TransferPublisher ensureTransferPublisher() {
        if (this.transferPublisher == null) {
            this.transferPublisher = new NostrTransferPublisher(this.nostrGateway);
        }
        return this.transferPublisher;
    }

    private DomainEventPublisher ensureDomainEventPublisher() {
        if (this.domainEventPublisher == null) {
            SynchronousDomainEventPublisher publisher = new SynchronousDomainEventPublisher();
            publisher.registerSubscriber(new CliLoggingSubscriber());
            for (DomainEventSubscriber subscriber : this.deferredSubscribers) {
                publisher.registerSubscriber(subscriber);
            }
            this.domainEventPublisher = publisher;
        }
        return this.domainEventPublisher;
    }

    private WalletRecoveryServiceFactory ensureRecoveryServiceFactory() {
        if (this.recoveryServiceFactory == null) {
            this.recoveryServiceFactory = new WalletRecoveryServiceFactory();
        }
        return this.recoveryServiceFactory;
    }

    private DmService ensureDmService() {
        if (this.dmService == null) {
            String protocol;
            Path home = StoragePaths.walletHome();
            IdentityKeyService idService = new IdentityKeyService(home);
            SecureKeyStore keystore = SecureKeyStore.create(home);
            WalletKeyManager walletKeyManager = new WalletKeyManager(keystore);
            switch (protocol = System.getProperty("wallet.dm.protocol", "nip44").toLowerCase()) {
                case "nip04": {
                    ServiceLoader<DmCrypto> nip04Loader = ServiceLoader.load(DmCrypto.class);
                    DmCrypto nip04 = nip04Loader.findFirst().orElse(null);
                    if (nip04 != null) {
                        this.dmService = new DmServiceNip04(idService, walletKeyManager, new GatewayDmAdapter(this.nostrGateway), nip04);
                        break;
                    }
                    this.dmService = new DmServiceNip04(idService, walletKeyManager, new GatewayDmAdapter(this.nostrGateway), new DmCryptoNip04());
                    break;
                }
                case "nip44": {
                    ServiceLoader<DmCrypto44> nip44Loader = ServiceLoader.load(DmCrypto44.class);
                    DmCrypto44 nip44 = nip44Loader.findFirst().orElse(null);
                    if (nip44 != null) {
                        this.dmService = new DmServiceNip44(idService, walletKeyManager, new GatewayDmAdapter(this.nostrGateway), nip44);
                        break;
                    }
                    this.dmService = new DmServiceNip44(idService, walletKeyManager, new GatewayDmAdapter(this.nostrGateway), new DmCryptoNip44());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported DM protocol. wallet.dm.protocol=" + protocol + ". Suggestion: Use 'nip04' or 'nip44', e.g., -Dwallet.dm.protocol=nip44.");
                }
            }
        }
        return this.dmService;
    }

    private VoucherService ensureVoucherService() {
        if (this.voucherService == null) {
            WalletStorage storage;
            BalanceService balanceService;
            EncryptionService encryptionService = new EncryptionService();
            if (this.service != null && (balanceService = this.service) instanceof H2WalletService) {
                H2WalletService h2Service = (H2WalletService)balanceService;
                storage = new H2WalletStorageAdapter(h2Service::getDataSource);
            } else {
                storage = new FileWalletStorage();
            }
            Path home = StoragePaths.walletHome();
            IdentityKeyService identityKeyService = new IdentityKeyService(home);
            DmService dmSvc = this.ensureDmService();
            ServiceLoader<DmCrypto44> nip44Loader = ServiceLoader.load(DmCrypto44.class);
            DmCrypto44 dmCrypto44 = nip44Loader.findFirst().orElseGet(DmCryptoNip44::new);
            VoucherBackupServiceImpl backupService = new VoucherBackupServiceImpl(dmSvc, dmCrypto44);
            BalanceService sendSvc = this.ensureSendService();
            if (!(sendSvc instanceof SendService)) {
                throw new IllegalStateException("VoucherService requires SendService for proof management");
            }
            SendService sendService = (SendService)sendSvc;
            this.voucherService = new VoucherServiceImpl(storage, encryptionService, backupService, identityKeyService, this.nostrGateway, sendService, this.tokenCodec);
        }
        return this.voucherService;
    }

    public void registerDomainEventSubscriber(DomainEventSubscriber subscriber) {
        if (subscriber == null) {
            return;
        }
        if (this.domainEventPublisher != null) {
            this.domainEventPublisher.registerSubscriber(subscriber);
        } else {
            this.deferredSubscribers.add(subscriber);
        }
    }

    private boolean requiresH2Backend() {
        return this.isH2Backend(this.ensureSendService()) || this.isH2Backend(this.ensureReceiveService());
    }

    private boolean isH2Backend(BalanceService svc) {
        return svc instanceof H2WalletService;
    }

    public NostrGatewayService nostrGateway() {
        return this.nostrGateway;
    }

    public void close() {
        WalletCliConfiguration.closeQuietly(this.service);
        if (this.sendServiceInstance != this.service) {
            WalletCliConfiguration.closeQuietly(this.sendServiceInstance);
        }
        if (this.receiveServiceInstance != this.service && this.receiveServiceInstance != this.sendServiceInstance) {
            WalletCliConfiguration.closeQuietly(this.receiveServiceInstance);
        }
    }

    private static void closeQuietly(Object candidate) {
        if (candidate instanceof AutoCloseable) {
            AutoCloseable c = (AutoCloseable)candidate;
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private <T> boolean hasConstructor(Class<?> targetClass, Class<T> constructorParamType) {
        try {
            targetClass.getDeclaredConstructor(constructorParamType);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean hasConstructor(Class<?> targetClass, Class<?> first, Class<?> second) {
        try {
            targetClass.getDeclaredConstructor(first, second);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean hasConstructor(Class<?> targetClass, Class<?> first, Class<?> second, Class<?> third) {
        try {
            targetClass.getDeclaredConstructor(first, second, third);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

