/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli;

import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletCliConfiguration;
import xyz.tcheeric.wallet.cli.commands.ApiVersionCmd;
import xyz.tcheeric.wallet.cli.commands.BackupWalletCmd;
import xyz.tcheeric.wallet.cli.commands.BalanceCmd;
import xyz.tcheeric.wallet.cli.commands.ChangePassphraseCmd;
import xyz.tcheeric.wallet.cli.commands.ConsolidateCmd;
import xyz.tcheeric.wallet.cli.commands.DmListCmd;
import xyz.tcheeric.wallet.cli.commands.DmSendCmd;
import xyz.tcheeric.wallet.cli.commands.EncryptCmd;
import xyz.tcheeric.wallet.cli.commands.ExportTokenCmd;
import xyz.tcheeric.wallet.cli.commands.GenerateMnemonicCmd;
import xyz.tcheeric.wallet.cli.commands.InfoCmd;
import xyz.tcheeric.wallet.cli.commands.Init;
import xyz.tcheeric.wallet.cli.commands.ListMintsCmd;
import xyz.tcheeric.wallet.cli.commands.ListProofsCmd;
import xyz.tcheeric.wallet.cli.commands.MeltCmd;
import xyz.tcheeric.wallet.cli.commands.MeltQuoteCmd;
import xyz.tcheeric.wallet.cli.commands.MintCmd;
import xyz.tcheeric.wallet.cli.commands.MintQuoteCmd;
import xyz.tcheeric.wallet.cli.commands.MintRegistryCmd;
import xyz.tcheeric.wallet.cli.commands.NostrGatewayCmd;
import xyz.tcheeric.wallet.cli.commands.QuoteStatusCmd;
import xyz.tcheeric.wallet.cli.commands.ReceiveCmd;
import xyz.tcheeric.wallet.cli.commands.RecoverWalletCmd;
import xyz.tcheeric.wallet.cli.commands.SendCmd;
import xyz.tcheeric.wallet.cli.commands.SetActiveMintCmd;
import xyz.tcheeric.wallet.cli.commands.ShowMnemonicCmd;
import xyz.tcheeric.wallet.cli.commands.StatusCmd;
import xyz.tcheeric.wallet.cli.commands.VerifyCmd;
import xyz.tcheeric.wallet.cli.commands.VerifyEncryptionCmd;
import xyz.tcheeric.wallet.cli.commands.VoucherCmd;
import xyz.tcheeric.wallet.core.BalanceService;

@CommandLine.Command(name="wallet", mixinStandardHelpOptions=true, version={"cashu-client 0.1"}, description={"Cashu wallet CLI. Use subcommands to mint, melt, consolidate, and inspect state. Add --json on supported commands for machine-readable output."}, subcommands={Init.class, GenerateMnemonicCmd.class, RecoverWalletCmd.class, BackupWalletCmd.class, ShowMnemonicCmd.class, BalanceCmd.class, InfoCmd.class, MintQuoteCmd.class, MeltQuoteCmd.class, QuoteStatusCmd.class, MintCmd.class, MeltCmd.class, SendCmd.class, ReceiveCmd.class, DmSendCmd.class, DmListCmd.class, ConsolidateCmd.class, StatusCmd.class, VerifyCmd.class, EncryptCmd.class, ChangePassphraseCmd.class, VerifyEncryptionCmd.class, ExportTokenCmd.class, ListProofsCmd.class, ApiVersionCmd.class, ListMintsCmd.class, MintRegistryCmd.class, SetActiveMintCmd.class, NostrGatewayCmd.class, VoucherCmd.class})
public class WalletMain
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WalletMain.class);
    @CommandLine.Option(names={"--json"}, description={"Output JSON where applicable"})
    public boolean jsonOutput;
    private final BalanceService service;

    public WalletMain(BalanceService service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) {
        int exit;
        log.info("Starting wallet CLI with args {}", (Object)Arrays.toString(args2));
        WalletCliConfiguration configuration = WalletCliConfiguration.fromDefaults();
        try {
            exit = configuration.commandLine().execute(args2);
        }
        catch (Exception e) {
            System.err.println("Error: " + WalletMain.extractUserMessage(e));
            log.error("Uncaught exception in wallet CLI", e);
            exit = 2;
        }
        finally {
            configuration.close();
            configuration.nostrGateway().close();
        }
        System.exit(exit);
    }

    private static String extractUserMessage(Exception e) {
        Object message = e.getMessage();
        if (message == null || ((String)message).isBlank()) {
            message = e.getClass().getSimpleName() + " occurred";
        }
        message = ((String)message).replaceAll("\\s+at\\s+[a-zA-Z0-9.$_]+\\([^)]+\\)", "");
        message = ((String)message).replaceAll("Caused by:.*", "");
        return ((String)message).trim();
    }

    @Override
    public void run() {
        CommandLine.usage(this, System.out);
    }
}

