/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.WalletServices;
import xyz.tcheeric.wallet.core.backup.BackupService;
import xyz.tcheeric.wallet.core.backup.WalletStateProvider;
import xyz.tcheeric.wallet.core.proof.ProofSummary;
import xyz.tcheeric.wallet.core.state.RelayMetadata;
import xyz.tcheeric.wallet.core.state.SchemaVersion;
import xyz.tcheeric.wallet.core.state.StoredVoucher;
import xyz.tcheeric.wallet.core.state.WalletSchemaMetadata;
import xyz.tcheeric.wallet.core.state.WalletState;
import xyz.tcheeric.wallet.core.state.WalletToken;

@CommandLine.Command(name="backup", description={"Create encrypted wallet backup"}, mixinStandardHelpOptions=true)
public class BackupWalletCmd
extends WalletServiceCommand<BalanceService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackupWalletCmd.class);
    @CommandLine.Option(names={"-o", "--output"}, description={"Backup file path (e.g., wallet-backup.enc)"}, required=true)
    File outputFile;
    @CommandLine.Option(names={"-p", "--passphrase"}, description={"Encryption passphrase for backup file"}, required=true, interactive=true, arity="0..1")
    String passphrase;
    @CommandLine.Option(names={"--json"}, description={"Export unencrypted JSON (WARNING: includes encrypted mnemonic)"})
    boolean json;
    private final BackupService backupService;
    private final WalletStateProvider walletStateProvider;

    public BackupWalletCmd(BackupService backupService, WalletStateProvider walletStateProvider) {
        super(WalletServices.createDefault());
        this.backupService = backupService;
        this.walletStateProvider = walletStateProvider;
    }

    public BackupWalletCmd() {
        super(WalletServices.createDefault());
        this.backupService = new BackupService();
        this.walletStateProvider = this::createBackupWalletState;
    }

    @Override
    public void run() {
        try {
            log.info("wallet_backup_started output={} encrypted={}", (Object)this.outputFile.getAbsolutePath(), (Object)(!this.json ? 1 : 0));
            WalletState walletState = this.walletStateProvider.loadWalletState();
            BackupService.BackupResult result = this.backupService.createBackup(walletState, this.outputFile, this.passphrase, this.json);
            this.displaySuccessMessage(result);
            log.info("wallet_backup_completed output={} size={}", (Object)result.getOutputFile().getAbsolutePath(), (Object)result.getFileSize());
        }
        catch (BackupService.BackupException e) {
            this.handleError(e);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private WalletState createBackupWalletState() {
        log.info("wallet_state_export_started retrieving_actual_wallet_data");
        try {
            WalletConfig config = WalletConfig.load();
            this.service.init(config);
            if (!(this.service instanceof H2WalletService)) {
                log.error("wallet_state_export_failed unsupported_service_type={}", (Object)this.service.getClass().getName());
                throw new IllegalStateException("Wallet backup requires H2WalletService but got " + this.service.getClass().getName());
            }
            H2WalletService h2Service = (H2WalletService)this.service;
            SchemaVersion schemaVersion = new SchemaVersion(1, 0);
            WalletSchemaMetadata metadata = new WalletSchemaMetadata(schemaVersion, schemaVersion, schemaVersion, List.of(), List.of());
            List<WalletToken> tokens = this.loadAllTokens(h2Service, config);
            log.info("wallet_state_export loaded_tokens count={}", (Object)tokens.size());
            String encryptedMnemonic = this.loadEncryptedMnemonic();
            List<StoredVoucher> vouchers = this.loadVouchers(h2Service);
            log.info("wallet_state_export loaded_vouchers count={}", (Object)vouchers.size());
            return new WalletState(metadata, Instant.now(), tokens, List.of(), List.of(), encryptedMnemonic, encryptedMnemonic != null && !encryptedMnemonic.isEmpty(), null, vouchers, null);
        }
        catch (Exception e) {
            log.error("wallet_state_export_failed error={}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to create wallet state for backup: " + e.getMessage(), e);
        }
    }

    private String loadEncryptedMnemonic() {
        try {
            Path mnemonicPath = StoragePaths.walletHome().resolve("mnemonic.enc");
            if (Files.exists(mnemonicPath, new LinkOption[0])) {
                String encryptedMnemonic = Files.readString(mnemonicPath, StandardCharsets.UTF_8).trim();
                log.info("wallet_state_export loaded_encrypted_mnemonic deterministic=true");
                return encryptedMnemonic;
            }
            log.debug("wallet_state_export mnemonic_not_found deterministic=false");
            return null;
        }
        catch (Exception e) {
            log.warn("wallet_state_export mnemonic_load_failed reason={}", (Object)e.getMessage());
            return null;
        }
    }

    private List<WalletToken> loadAllTokens(H2WalletService h2Service, WalletConfig config) {
        ArrayList<WalletToken> walletTokens = new ArrayList<WalletToken>();
        String mintUrl = config.defaultMintUrl();
        String defaultUnit = config.defaultUnit();
        List<ProofSummary> proofs = h2Service.listProofSummaries(defaultUnit, mintUrl, null, null, null, false, 10000);
        log.debug("wallet_state_export loaded_proofs mint={} unit={} count={}", mintUrl, defaultUnit, proofs.size());
        if (proofs.isEmpty()) {
            return walletTokens;
        }
        String tokenId = "backup-token-" + Instant.now().toEpochMilli();
        long totalAmount = proofs.stream().mapToLong(ProofSummary::amount).sum();
        List<String> proofIds = proofs.stream().limit(100L).map(p -> p.cHex().substring(0, Math.min(16, p.cHex().length()))).toList();
        WalletToken walletToken = new WalletToken(mintUrl, tokenId, totalAmount, defaultUnit, proofs.get(0).createdAt(), proofIds, RelayMetadata.UNKNOWN);
        walletTokens.add(walletToken);
        return walletTokens;
    }

    private List<StoredVoucher> loadVouchers(H2WalletService h2Service) {
        try {
            DataSource dataSource = h2Service.getDataSource();
            ArrayList<StoredVoucher> vouchers = new ArrayList<StoredVoucher>();
            try (Connection connection = dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT voucher_id, unit, face_value, memo, status, issuer_id, issued_at, expires_at, issuer_signature, issuer_public_key FROM vouchers ORDER BY issued_at DESC");
                 ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    StoredVoucher voucher = new StoredVoucher(rs.getString("voucher_id"), rs.getString("issuer_id"), rs.getString("unit"), rs.getLong("face_value"), rs.getTimestamp("expires_at") != null ? Long.valueOf(rs.getTimestamp("expires_at").getTime()) : null, rs.getString("memo"), rs.getString("issuer_signature"), rs.getString("issuer_public_key"), rs.getTimestamp("issued_at") != null ? rs.getTimestamp("issued_at").toInstant() : Instant.now(), rs.getString("status"));
                    vouchers.add(voucher);
                }
            }
            log.debug("wallet_state_export loaded_vouchers_from_database count={}", (Object)vouchers.size());
            return vouchers;
        }
        catch (Exception e) {
            log.warn("wallet_state_export voucher_load_failed reason={} returning_empty_list", (Object)e.getMessage());
            return List.of();
        }
    }

    private void displaySuccessMessage(BackupService.BackupResult result) {
        System.out.println("\n\u2705 Wallet backup created successfully!");
        System.out.println("\u2501".repeat(80));
        System.out.println("   File: " + result.getOutputFile().getAbsolutePath());
        System.out.println("   Size: " + result.getFileSize() + " bytes");
        System.out.println("   Encrypted: " + (result.isEncrypted() ? "Yes (AES-256-GCM)" : "No (JSON)"));
        System.out.println("   Deterministic: " + (result.isDeterministicWallet() ? "Yes (BIP39)" : "No (Random)"));
        System.out.println("   Tokens: " + result.getTokenCount());
        System.out.println("   Vouchers: " + result.getVoucherCount());
        System.out.println("   History: " + result.getHistoryCount() + " events");
        System.out.println("\u2501".repeat(80));
        if (!result.isEncrypted()) {
            System.out.println("\n\u26a0\ufe0f  SECURITY WARNING:");
            System.out.println("   \u2022 Unencrypted JSON backup contains encrypted mnemonic");
            System.out.println("   \u2022 Store this file securely");
            System.out.println("   \u2022 Consider using encrypted backup (remove --json flag)");
        } else {
            System.out.println("\n\ud83d\udd12 Backup is encrypted with AES-256-GCM");
            System.out.println("   \u2022 Keep the passphrase secure");
            System.out.println("   \u2022 You'll need it to restore the wallet");
        }
        System.out.println();
    }

    private void handleError(Exception e) {
        System.err.println("\n\u274c Wallet backup failed: " + e.getMessage());
        System.err.println("Suggestion: Check the error message above and verify your inputs");
        log.error("wallet_backup_failed error={}", (Object)e.getMessage(), (Object)e);
    }
}

