/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.util.Map;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.Balance;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="balance", description={"Show balances per unit"})
public class BalanceCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.ParentCommand
    WalletMain parent;

    public BalanceCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        this.service.init(config);
        Balance bal = this.service.balance();
        if (this.parent != null && this.parent.jsonOutput) {
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{\"balances\":{");
            boolean first = true;
            for (Map.Entry<String, Long> e : bal.totalsByUnit().entrySet()) {
                if (!first) {
                    jsonBuilder.append(',');
                }
                first = false;
                jsonBuilder.append('\"').append(e.getKey()).append("\":").append(e.getValue());
            }
            jsonBuilder.append("}}\n");
            System.out.print(jsonBuilder.toString());
        } else {
            for (Map.Entry<String, Long> e : bal.totalsByUnit().entrySet()) {
                System.out.println(String.valueOf(e.getValue()) + " " + e.getKey());
            }
        }
    }
}

