/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="change-passphrase", description={"Change encryption passphrase. Requires H2 backend."})
public class ChangePassphraseCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;
    @CommandLine.Option(names={"--current"}, required=true)
    String current;
    @CommandLine.Option(names={"--next"}, required=true)
    String next;

    public ChangePassphraseCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        String mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        this.service.init(new WalletConfig(mintUrl, this.unit));
        BalanceService balanceService = this.service;
        if (!(balanceService instanceof H2WalletService)) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "H2 backend required. WALLET_STORAGE must be set to 'h2'. Suggestion: Export WALLET_STORAGE=h2 and retry.");
        }
        H2WalletService h2Service = (H2WalletService)balanceService;
        String kdf = System.getProperty("wallet.kdf", "");
        h2Service.changeEncryptionPassphrase(this.unit, mintUrl, this.current, this.next, kdf);
        System.out.println("Passphrase changed.");
    }
}

