/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.CliUtils;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.MintingService;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="consolidate", description={"Consolidate proofs into binary denominations within the active keyset. Requires H2 backend."})
public class ConsolidateCmd
extends WalletServiceCommand<MintingService> {
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;

    public ConsolidateCmd(MintingService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        String mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        CliUtils.ensureH2Backend();
        ((MintingService)this.service).init(new WalletConfig(mintUrl, this.unit));
        ((MintingService)this.service).consolidate(this.unit, mintUrl);
        System.out.println("Consolidation complete for unit " + this.unit + " on " + mintUrl);
    }
}

