/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.core.nostr.dm.DmMessage;
import xyz.tcheeric.wallet.core.nostr.dm.DmService;

@CommandLine.Command(name="dm-list", description={"List decrypted Nostr direct messages (NIP-04)"})
public class DmListCmd
implements Runnable {
    @CommandLine.ParentCommand
    WalletMain parent;
    private final DmService dmService;
    @CommandLine.Option(names={"--since"}, description={"Lower bound timestamp (epoch seconds)"})
    Long since;
    @CommandLine.Option(names={"--until"}, description={"Upper bound timestamp (epoch seconds)"})
    Long until;
    @CommandLine.Option(names={"--limit"}, description={"Max messages to return (default: 50)"})
    int limit = 50;
    @CommandLine.Option(names={"--authors"}, description={"Comma-separated sender pubkeys (hex)"})
    String authors;
    @CommandLine.Option(names={"--recipients"}, description={"Comma-separated recipient pubkeys (hex)"})
    String recipients;

    public DmListCmd(DmService dmService) {
        this.dmService = Objects.requireNonNull(dmService);
    }

    @Override
    public void run() {
        List<String> authorList = DmListCmd.splitOpt(this.authors);
        List<String> recipientList = DmListCmd.splitOpt(this.recipients);
        DmService.DmQuery query = new DmService.DmQuery(this.since != null ? Instant.ofEpochSecond(this.since) : null, this.until != null ? Instant.ofEpochSecond(this.until) : null, this.limit, authorList, recipientList);
        List<DmMessage> messages = this.dmService.list(query);
        if (this.parent != null && this.parent.jsonOutput) {
            String json = messages.stream().map(m -> "{\"eventId\":\"" + m.eventId() + "\",\"sender\":\"" + m.senderPubkeyHex() + "\",\"recipient\":\"" + m.recipientPubkeyHex() + "\",\"content\":\"" + DmListCmd.escape(m.content()) + "\",\"createdAt\":" + m.createdAt().getEpochSecond() + "}").collect(Collectors.joining(",", "[", "]"));
            System.out.println(json);
        } else {
            for (DmMessage m2 : messages) {
                System.out.println(String.valueOf(m2.createdAt()) + " sender=" + m2.senderPubkeyHex() + " recipient=" + m2.recipientPubkeyHex() + " id=" + m2.eventId() + "\n  " + m2.content());
            }
        }
    }

    private static List<String> splitOpt(String v) {
        if (v == null || v.isBlank()) {
            return List.of();
        }
        return Arrays.stream(v.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }
}

