/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.util.Objects;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendRequest;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendResult;
import xyz.tcheeric.wallet.core.nostr.dm.DmService;

@CommandLine.Command(name="dm-send", description={"Send an encrypted Nostr direct message (NIP-04)"})
public class DmSendCmd
implements Runnable {
    @CommandLine.ParentCommand
    WalletMain parent;
    private final DmService dmService;
    @CommandLine.Option(names={"--to"}, required=true, description={"Recipient Nostr pubkey (x-only hex)"})
    String recipient;
    @CommandLine.Option(names={"--content"}, required=true, description={"Message content to encrypt and send"})
    String content;

    public DmSendCmd(DmService dmService) {
        this.dmService = Objects.requireNonNull(dmService);
    }

    @Override
    public void run() {
        DmSendResult result = this.dmService.send(DmSendRequest.now(this.recipient, this.content));
        if (this.parent != null && this.parent.jsonOutput) {
            System.out.println("{\"eventId\":\"" + result.eventId() + "\"}");
        } else {
            System.out.println("DM sent, eventId=" + result.eventId());
        }
    }
}

