/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.io.Console;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="encrypt", description={"Enable encryption for stored secrets. Requires H2 backend."})
public class EncryptCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;
    @CommandLine.Option(names={"--passphrase"}, description={"Passphrase (or set WALLET_PASSPHRASE)"})
    String pass;

    public EncryptCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        Console console;
        String passphrase;
        String mintUrl;
        WalletConfig config = WalletConfig.load();
        String string = mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        if (!"h2".equalsIgnoreCase(System.getenv().getOrDefault("WALLET_STORAGE", "file"))) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "encrypt requires WALLET_STORAGE=h2");
        }
        String string2 = passphrase = this.pass != null ? this.pass : System.getenv().getOrDefault("WALLET_PASSPHRASE", "");
        if (passphrase.isEmpty() && (console = System.console()) != null) {
            char[] chars = console.readPassword("Enter passphrase: ", new Object[0]);
            String string3 = passphrase = chars != null ? new String(chars) : "";
        }
        if (passphrase.isEmpty()) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "Passphrase required. No passphrase provided via flag or prompt. Suggestion: Provide --passphrase, set WALLET_PASSPHRASE, or use the interactive prompt.");
        }
        this.service.init(new WalletConfig(mintUrl, this.unit));
        BalanceService balanceService = this.service;
        if (!(balanceService instanceof H2WalletService)) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "H2 backend required. WALLET_STORAGE must be set to 'h2'. Suggestion: Export WALLET_STORAGE=h2 and retry.");
        }
        H2WalletService h2Service = (H2WalletService)balanceService;
        this.migrateSecretsToEncryptedStorage(h2Service, this.unit, mintUrl, passphrase);
        System.out.println("Encryption enabled and secrets migrated.");
    }

    private void migrateSecretsToEncryptedStorage(H2WalletService service, String unit, String mintUrl, String passphrase) {
        service.migrateToEncryption(unit, mintUrl, passphrase);
    }
}

